/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final Logger log = LoggerFactory.getLogger(RSAUtils.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA";
    private static final String DEFAULT_SIGNATURE_MODE = "SHA256WithRSA/PSS";

    public static PublicKey getPublicKey(String key) {
        byte[] keyBytes = Base64EncodeUtils.decodeOfByteArray(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = null;
        PublicKey publicKey = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            log.error("get PublicKey error.", (Throwable)e);
        }
        return publicKey;
    }

    public static String decrypt(PublicKey publicKey, String enStr) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, publicKey);
            byte[] deBytes = cipher.doFinal(Base64EncodeUtils.decodeOfByteArray(enStr));
            return new String(deBytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            log.error("decrypt error.", (Throwable)e);
            return "";
        }
    }

    public static boolean verify(byte[] data, String publicKey, byte[] sign) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_MODE);
            signature.initVerify(RSAUtils.getPublicKey(publicKey));
            signature.update(data);
            return signature.verify(sign);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

