/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import java.util.Collection;
import java.util.Map;

public final class VerifyUtil {
    private static final int STRING_MAX_LENGTH = 4000;
    private static final long START_TIME = -2209017600000L;
    private static final long END_TIME = 4102415999000L;

    private VerifyUtil() {
    }

    public static boolean isRightLong(Object value) {
        try {
            return !VerifyUtil.isEmpty(value) && Long.parseLong(value.toString()) > Long.MIN_VALUE && Long.parseLong(value.toString()) < Long.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRightDouble(Object value) {
        return !VerifyUtil.isEmpty(value) && Double.parseDouble(value.toString()) > Double.MIN_VALUE && Double.parseDouble(value.toString()) < Double.MAX_VALUE;
    }

    public static boolean isRightInteger(Object value) {
        return !VerifyUtil.isEmpty(value) && Integer.parseInt(value.toString()) > Integer.MIN_VALUE && Integer.parseInt(value.toString()) < Integer.MAX_VALUE;
    }

    public static boolean isRightTime(long time) {
        return time > -2209017600000L && time < 4102415999000L;
    }

    public static boolean isRightTime(Object time) {
        return !VerifyUtil.isEmpty(time) && VerifyUtil.isRightTime(Long.parseLong(time.toString()));
    }

    public static boolean isRightString(String string) {
        return !VerifyUtil.isEmpty(string) && string.length() < 4000;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.isEmpty();
    }

    public static boolean isEmpty(Object obj) {
        return null == obj;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map, Object key) {
        if (VerifyUtil.isEmpty(map)) {
            return true;
        }
        return !map.containsKey(key) || null == map.get(key) || "".equals(map.get(key));
    }

    public static boolean isEmpty(String string) {
        return null == string || string.isEmpty();
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isEmpty(Object[][] objects) {
        if (objects == null || objects.length == 0) {
            return true;
        }
        for (Object[] objectArray : objects) {
            if (objectArray.length == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMultiEmpty(Object ... obj) {
        if (obj == null) {
            return true;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (null == obj[i]) {
                return true;
            }
            if (!(obj[i] instanceof String) || !VerifyUtil.isEmpty(obj[i].toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultiNullStr(Object obj) {
        if (obj == null) {
            return true;
        }
        return VerifyUtil.isEmpty(obj.toString());
    }

    public static boolean checkEmptyParams(Object obj, Object ... objs) {
        if (VerifyUtil.isEmpty(obj) || null == objs) {
            return true;
        }
        for (Object o : objs) {
            if (!VerifyUtil.isEmpty(o)) continue;
            return true;
        }
        return false;
    }
}

