/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.plugin;

import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.platform.util.PlatformUtils;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktakerFactory;

public abstract class AbstractPlugin {
    private static final String DEFAULT_CONFIG_DIR = "config";
    private static final String DEFAULT_WORKTAKER_DIR = "worktaker";
    private static final String DEFAULT_WORKTAKER_FIEL = "worktaker.ini";
    protected AbstractRuntime runtime = null;
    private AbstractWorktakerFactory wktkFactory = null;

    public String getId() {
        return PlatformUtils.getPluginId(this.getClass());
    }

    public boolean doInit(AbstractRuntime abRuntime) {
        this.runtime = abRuntime;
        ClassLoader cl = this.getClass().getClassLoader();
        String id = this.getId();
        this.wktkFactory = abRuntime.createWorktakerFactory(this.getWorktakerCfg(), cl);
        AbstractContext context = this.getContext();
        if (null != context) {
            context.setPluginId(id);
        }
        return this.init();
    }

    public abstract void registerSuccess(String var1);

    public abstract void registerFailed(String var1);

    protected abstract boolean init();

    protected abstract AbstractContext getContext();

    protected String getWorktakerCfg() {
        return "config/" + this.getId() + '/' + DEFAULT_WORKTAKER_DIR + '/' + DEFAULT_WORKTAKER_FIEL;
    }

    public AbstractWorktakerFactory getWktkFactory() {
        return this.wktkFactory;
    }
}

