/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.TooliniParser;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.common.data.DeviceMode;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolData;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.common.toolbox.INoticeRefresh;
import com.huawei.ism.tool.framework.platform.common.toolbox.IStartBsChangeListener;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.listener.HookHandler;
import com.huawei.ism.tool.framework.platform.listener.IListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.platform.runtime.impl.AppletRuntime;
import com.huawei.ism.tool.framework.platform.task.IBackgroundTask;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.common.IHttpSession;
import com.huawei.ism.tool.framework.pubui.entity.UpdateStatus;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ApplicationContext {
    private static final int SLEEP = 500;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ApplicationContext.class);
    private static final String TOOLBOX = "toolbox_";
    private static final String WINDOWS = "Windows";
    private static final String COMMAND = "wmic cpu get processorid";
    private static final String OS_NAME = "os.name";
    private static final String PROCESS_ID = "ProcessorId";
    private static final String MAX_UNZIP_FILE_SIZE = "app.max.unzip.size";
    private static final String MAX_UNZIP_FILE_NUM = "app.max.unzip.file.num";
    private static final String LOG_STR = ".log";
    private static AbstractRuntime runtime = PlatformAppContext.getInstance().getRuntime();
    private FileOutputStream fos = null;
    private BlockingDeque<Thread> threads = new LinkedBlockingDeque<Thread>();
    private boolean showUpdate = false;
    private boolean blockLcokRealese = true;
    private volatile boolean upgradeFlag = false;
    private boolean remind = false;
    private Map<String, String> sslVersionMap = new HashMap<String, String>();
    private List<DeviceMode> deviceModeList = new ArrayList<DeviceMode>();
    private String deviceGraphCfgPath = null;
    private String HDDeviceGraphCfgPath = null;
    private String deviceImgCfgPath = null;
    private String HDDeviceImgCfgPath = null;
    private String toolTypeName = null;
    private String userField = "";
    private String itemNodeFiled = "";
    private boolean isEdit = false;
    private String filePath = null;
    private boolean fileChooserPathLenLimit = true;
    private String userRole = "";
    private boolean isInitUserRole;
    private UserOpToolData userOpData;
    private String sceneDialogFlag = "";
    private static final String SENCEOPERATE_XML = "userAreaSelected.xml";
    private boolean toolStoreActivated = false;
    private UpdateStatus updateRemindStatus;
    private UpdateStatus certificationRemindStatus;
    private String toolboxUploadFileName = "";
    private String importFileName = "";
    private String toolboxFileName = "";
    private String sceneFileName = "";
    private String supportUser = "unKnown";
    private String userRight = "";
    private ToolLoginUser toolLoginUser = new ToolLoginUser();
    private boolean needLogin = false;
    private boolean customerImprove = false;
    private boolean netConnectFailed = false;
    private static final String TOOLSFOLDER = "tools";
    private static final String UPDATECHECKER = "updatechecker";
    private boolean showActivatingDialog = false;
    private List<IHttpSession> httpSessionList = new ArrayList<IHttpSession>();
    private String applySupportType = "";
    private boolean isOEM = false;
    private static final String OEM_VENDER = "OEM";
    private static final String VENDER_KEY = "tool.vendor";
    private boolean isHDGraph;
    private String userIdentity = "";
    private boolean isAgreePrivacyStateFlag;
    private boolean toolboxUpdate = false;
    private boolean toolUpdate = false;
    private boolean patchUpdate = false;
    private static ApplicationContext instance = new ApplicationContext();
    private boolean isSimulatorFlag;
    private HookHandler hookHandler = null;
    private String curSceneStepName = "";
    private INoticeRefresh noticePanelInter;
    private IStartBsChangeListener startBsChangeListener;
    private String bsLogFilePath = "";
    private boolean validSign = true;
    private String curToolkitUser = System.getProperty("user.name");
    private static final String RUNING_LOG_PATH = "app.log.path";

    public boolean isHDGraph() {
        return this.isHDGraph;
    }

    public void setHDGraph(boolean HDGraph) {
        this.isHDGraph = HDGraph;
    }

    public String getUserIdentity() {
        return this.userIdentity;
    }

    public void setUserIdentity(String userIdentity) {
        this.userIdentity = userIdentity;
    }

    private ApplicationContext() {
        String vendor = TooliniParser.getToolIniProp(VENDER_KEY);
        this.setOEM(vendor.equalsIgnoreCase(OEM_VENDER));
    }

    public ToolLoginUser getToolLoginUser() {
        if (LocalHostUtil.isRunInSvp()) {
            ToolLoginUser user = new ToolLoginUser("SVP_User", ToolUserRole.HWENGINEER, ToolUserRole.HWENGINEER);
            user.setBuildInUser(true);
            return user;
        }
        return this.toolLoginUser;
    }

    public void setToolLoginUser(ToolLoginUser toolLoginUser) {
        this.toolLoginUser = toolLoginUser;
    }

    public boolean isToolStoreActivated() {
        return this.toolStoreActivated;
    }

    public UserOpToolData getUserOpData() {
        return this.userOpData;
    }

    public void setUserOpData(UserOpToolData userOpData) {
        this.userOpData = userOpData;
    }

    public void setToolStoreActivated(boolean toolStoreActivated) {
        this.toolStoreActivated = toolStoreActivated;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isFileChooserPathLenLimit() {
        return this.fileChooserPathLenLimit;
    }

    public void setFileChooserPathLenLimit(boolean fileChooserPathLenLimit) {
        this.fileChooserPathLenLimit = fileChooserPathLenLimit;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getSceneDialogFlag() {
        return this.sceneDialogFlag;
    }

    public void setSceneDialogFlag(String sceneDialogFlag) {
        this.sceneDialogFlag = sceneDialogFlag;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getItemNodeFiled() {
        return this.itemNodeFiled;
    }

    public void setItemNodeFiled(String itemNodeFiled) {
        this.itemNodeFiled = itemNodeFiled;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public boolean isBlockLcokRealese() {
        return this.blockLcokRealese;
    }

    public void setBlockLcokRealese(boolean blockLcokRealese) {
        this.blockLcokRealese = blockLcokRealese;
    }

    public boolean isCallHomeEnv() {
        return true;
    }

    public void setToolLockStream(FileOutputStream fops) {
        this.fos = fops;
    }

    public FileOutputStream getToolLockStream() {
        return this.fos;
    }

    public boolean isRemoteLogic() {
        return runtime instanceof AppletRuntime;
    }

    public static synchronized ApplicationContext getInstance() {
        return instance;
    }

    public String getUtils() {
        return DataType.utils.getDirName();
    }

    public boolean isSimulatorFlag() {
        return this.isSimulatorFlag;
    }

    public void setSimulatorFlag(boolean simulatorFlagParm) {
        this.isSimulatorFlag = simulatorFlagParm;
    }

    public String getWorkPath() {
        return runtime.getWorkPath();
    }

    public String getHelpPath() {
        return DataType.help.getDirName();
    }

    public String getTmpPath() {
        return DataType.temp.getDirName();
    }

    public String getLibPath() {
        return DataType.lib.getDirName();
    }

    public String getCfgPath() {
        return DataType.cfg.getDirName();
    }

    public String getPluginsCfgPath() {
        return DataType.applicationCfg.getDirName();
    }

    public String getExtToolsPath() {
        return DataType.tools.getDirName();
    }

    public String getManualPath() {
        return DataType.manual.getDirName();
    }

    public String getScriptPath() {
        return DataType.script.getDirName();
    }

    public String getSmartKitToolPath() {
        File dir;
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (workPath.endsWith(UPDATECHECKER) && (dir = new File(workPath)).exists()) {
            workPath = dir.getParent();
        }
        return workPath;
    }

    public String getExtToolRefreshPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getWorkPath() + File.separator);
        sb.append(this.getTmpPath() + File.separator);
        sb.append("refreshData");
        return sb.toString();
    }

    public String getToolRefreshPath() {
        StringBuffer sb = new StringBuffer();
        return sb.append(this.getToolPath()).append(this.getTmpPath() + File.separator).append("refreshData").toString();
    }

    public String getToolPath() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        return workPath.contains(TOOLSFOLDER) ? workPath.split(TOOLSFOLDER)[0] : workPath;
    }

    public String getDownloadPath() {
        return DataType.updates.getDirName();
    }

    public String getPluginPath() {
        return DataType.plugins.getDirName();
    }

    public String getSceneFilePath() {
        return DataType.scene.getDirName();
    }

    public String getVersion() {
        return runtime.getVersion();
    }

    public String getReleaseDate() {
        return runtime.getReleaseDate();
    }

    public String getReleaseTimeMark() {
        return runtime.getReleaseTimeMark();
    }

    public String getSupportEncryptionAlgorithm() {
        return runtime.getSupportEncryptionAlgorithm();
    }

    public String getVender() {
        return runtime.getVender();
    }

    public String getUserDataPath() {
        return DataType.data.getDirName();
    }

    public Locale[] getSupportedLans() {
        return runtime.getSupportedLans();
    }

    public boolean isEnglishEnv() {
        return runtime.isEnglishEnv();
    }

    public String getCurrentJreVersion() {
        return runtime.getJreVersion();
    }

    public boolean currentJreIsSupport() {
        return runtime.isJreSupported();
    }

    public String getSystemTempPath() {
        return runtime.getSystemTempPath();
    }

    public boolean isOldUI() {
        return "traditional".equalsIgnoreCase(this.getAppConfig("app.ui.type"));
    }

    public boolean isSpecificDeviceMode() {
        return LocalHostUtil.isRunInV3LaterSvp() || "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.mode.enalbed"));
    }

    public boolean isSpecificDeviceModeConfigured() {
        return "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.mode.enalbed"));
    }

    public String getDeviceType() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !ApplicationContext.getInstance().isSpecificDeviceMode()) {
            return "HVS";
        }
        return this.getAppConfig("app.specific.device.type");
    }

    public String getDeviceInnerIPs() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("isSpecificDeviceModeConfigured():" + this.isSpecificDeviceModeConfigured());
        }
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return this.getAppConfig("app.specific.device.v3r3.inner.ips");
        }
        return this.getAppConfig("app.specific.device.inner.ips");
    }

    public String getDeviceIP() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return this.getAppConfig("app.specific.device.v3r3.ip");
        }
        return this.getAppConfig("app.specific.device.ip");
    }

    public boolean isDeviceUsingSSL() {
        if (LocalHostUtil.isRunInV3LaterSvp() && !this.isSpecificDeviceModeConfigured()) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getAppConfig("app.specific.device.ssl"));
    }

    public boolean isWindowsOS() {
        return runtime.isWindowsOS();
    }

    public String getSystemCfg(String key) {
        return runtime.getAppConfig(key);
    }

    public void setJunitIsOpen() {
        runtime.setJUnitMode();
    }

    public boolean isJunit() {
        return runtime.isJunit();
    }

    public String getAppConfig(String key) {
        return runtime.getAppConfig(key);
    }

    public final long getMaxUnzipFileSize() {
        long maxSizeNum = 0L;
        String maxSize = ApplicationContext.getInstance().getAppConfigNoExcept(MAX_UNZIP_FILE_SIZE);
        return this.getValueOrDefault(maxSize, 0L);
    }

    public final long getMaxUnzipFileNum() {
        boolean maxSizeNum = false;
        String maxSize = ApplicationContext.getInstance().getAppConfigNoExcept(MAX_UNZIP_FILE_NUM);
        return this.getValueOrDefault(maxSize, 0L);
    }

    private long getValueOrDefault(String src, long defaultValue) {
        try {
            if (StringUtils.isNULLStr(src)) {
                return defaultValue;
            }
            return Long.parseLong(src);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid num str {} , use default value {} .", (Object)src, (Object)defaultValue);
            return defaultValue;
        }
    }

    public String getAppConfigNoExcept(String key) {
        try {
            return this.getAppConfig(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isVerifySshHostKey() {
        String hostCheck = UserOpDataSaveUtil.getToolBoxIniProp("ssh.should.verify.public.key.strictHostKeyChecking");
        return Boolean.parseBoolean(VerifyUtil.isEmpty(hostCheck) ? "" : hostCheck.trim());
    }

    public File getUserCfgFile() {
        return runtime.getUserCfgFile();
    }

    public AbstractToolBox getToolContainer() {
        return PlatformAppContext.getInstance().getToolBox();
    }

    public void fireToolStarted(String toolId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (null != toolBox) {
            toolBox.fireToolStarted(toolId);
        }
    }

    public void fireToolStopped(String toolId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (null == toolBox) {
            LOGGER.error("[title=application_shutdown] fail to shutdown: tool box is null");
            return;
        }
        toolBox.fireToolStopped(toolId);
    }

    public void addBackgroundTask(IBackgroundTask task) {
        PlatformAppContext.getInstance().addBackgroundTask(task);
    }

    public void removeBackgroundTask(IBackgroundTask task) {
        PlatformAppContext.getInstance().removeBackgroundTask(task);
    }

    public List<IBackgroundTask> getBackgroundTasks() {
        return PlatformAppContext.getInstance().getBackgroundTasks();
    }

    public List<AbstractTool> getTools() {
        return PlatformAppContext.getInstance().getTools();
    }

    public BlockingDeque<Thread> getThreads() {
        return this.threads;
    }

    public void showDialogs() {
        block2: while (!this.threads.isEmpty()) {
            Thread tmpThread = (Thread)this.threads.pollLast();
            if (null == tmpThread) {
                throw new NullPointerException();
            }
            ToolLoggerFactory.getLogger(this.getClass()).info("thread name : " + tmpThread.getName());
            tmpThread.start();
            while (tmpThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("thread error!", (Throwable)e);
                    continue block2;
                }
            }
        }
    }

    public String getCurToolkitUser() {
        return this.curToolkitUser;
    }

    public void setCurToolkitUser(String curToolkitUser) {
        this.curToolkitUser = curToolkitUser;
    }

    public boolean isShowUpdate() {
        return this.showUpdate;
    }

    public void setShowUpdate(boolean showUpdate) {
        this.showUpdate = showUpdate;
    }

    public boolean isRemind() {
        return this.remind;
    }

    public void setRemind(boolean remind) {
        this.remind = remind;
    }

    public String getDevSslVersion(String devIp) {
        return this.sslVersionMap.get(devIp);
    }

    public void addDevSslVersion(String devIp, String sslVersion) {
        this.sslVersionMap.put(devIp, sslVersion);
    }

    public void addListener(IListener listener) {
        runtime.addListener(listener);
    }

    public void removeListener(IListener listener) {
        runtime.removeListener(listener);
    }

    public <T> List<T> getListenerList(Class<T> classType) {
        return runtime.getListenerList(classType);
    }

    public String getHDDeviceImgCfgPath() {
        return this.HDDeviceImgCfgPath;
    }

    public void setHDDeviceImgCfgPath(String HDDeviceImgCfgPath) {
        this.HDDeviceImgCfgPath = HDDeviceImgCfgPath;
    }

    public String getHDDeviceGraphCfgPath() {
        return this.HDDeviceGraphCfgPath;
    }

    public void setHDDeviceGraphCfgPath(String HDDeviceGraphCfgPath) {
        this.HDDeviceGraphCfgPath = HDDeviceGraphCfgPath;
    }

    public void setDeviceGraphCfgPath(String deviceGraphCfgPath) {
        this.deviceGraphCfgPath = deviceGraphCfgPath;
    }

    public String getDeviceGraphCfgPath() {
        return this.deviceGraphCfgPath;
    }

    public void setDeviceImgCfgPath(String deviceImgCfgPath) {
        this.deviceImgCfgPath = deviceImgCfgPath;
    }

    public String getDeviceImgCfgPath() {
        return this.deviceImgCfgPath;
    }

    public String getToolTypeName() {
        return this.toolTypeName;
    }

    public void setToolTypeName(String toolTypeName) {
        this.toolTypeName = toolTypeName;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean edit) {
        this.isEdit = edit;
    }

    public String getToolboxUploadFileName() {
        return this.toolboxUploadFileName;
    }

    public void setToolboxUploadFileName(String toolboxUploadFileName) {
        this.toolboxUploadFileName = toolboxUploadFileName;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public String getToolboxFileName() {
        return this.toolboxFileName;
    }

    public void setToolboxFileName(String toolboxFileName) {
        this.toolboxFileName = toolboxFileName;
    }

    public String getSceneFileName() {
        return this.sceneFileName;
    }

    public void setSceneFileName(String sceneFileName) {
        this.sceneFileName = sceneFileName;
    }

    public String getRunnigLogPath() {
        String runningLogPath = this.getRunningLogPath();
        if (ApplicationContext.isNullStr(runningLogPath)) {
            return this.getWorkPath();
        }
        return runningLogPath;
    }

    private final String getRunningLogPath() {
        String runtimeDataPath = ApplicationContext.getInstance().getAppConfig(RUNING_LOG_PATH);
        if (ApplicationContext.isNullStr(runtimeDataPath)) {
            return "";
        }
        File runtimeFile = new File(runtimeDataPath);
        if (runtimeFile.exists() && !runtimeFile.isDirectory()) {
            return "";
        }
        if (!runtimeFile.exists() && !runtimeFile.mkdirs()) {
            return "";
        }
        try {
            return runtimeFile.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static boolean isNullStr(String str) {
        return null == str || "".equals(str.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUserAreaSelected() {
        String xmlFileAbsolutePath = ApplicationContext.getInstance().getXmlAbsolutePath();
        File file = new File(xmlFileAbsolutePath);
        if (file.exists() && !this.isInitUserRole) {
            FileInputStream xmlInput = null;
            try {
                xmlInput = new FileInputStream(file);
                Document docXMLUserAreaSelected = XmlUtils.parseDocument(xmlInput);
                Element userAreaRoot = docXMLUserAreaSelected.getDocumentElement();
                if ("".equals(this.userField)) {
                    Element userArea = (Element)userAreaRoot.getElementsByTagName("userArea").item(0);
                    String userAreaSelected = userArea.getTextContent();
                    this.setUserField(userAreaSelected);
                }
                Element userRoleElement = XmlUtils.getChild(userAreaRoot, "sceneIntroducedialog");
                if ("".equals(this.userRole)) {
                    String role = XmlUtils.getTextContentOfChild(userRoleElement, "userType");
                    this.setUserRole(role);
                }
                if ("".equals(this.sceneDialogFlag)) {
                    String introduceDialogFlag = XmlUtils.getTextContentOfChild(userRoleElement, "sceneShow");
                    this.setSceneDialogFlag(introduceDialogFlag);
                }
                this.isInitUserRole = true;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("\u6253\u5f00XML\u5931\u8d25\uff0c\u6216\u8005\u8bfb\u53d6XML\u5931\u8d25\uff01" + xmlFileAbsolutePath, (Throwable)e);
            }
            finally {
                StreamUtils.closeStream(null, xmlInput);
            }
        } else if (!this.isInitUserRole) {
            if ("".equals(this.userField)) {
                this.setUserField("Storage");
            }
            if ("".equals(this.sceneDialogFlag)) {
                this.setSceneDialogFlag("IsTheFirstTime");
            }
            if ("".equals(this.userRole)) {
                this.setUserRole("EnterPrise");
            }
        }
    }

    public void createUserXml(String pathXMLUserAreaSelected) throws ToolException {
        Document xmlDoc = XmlWriter.createNewDocument();
        Element root = XmlWriter.createTagElement(xmlDoc, "userAreaRoot");
        xmlDoc.appendChild(root);
        if (null == this.userField || this.userField.isEmpty()) {
            this.userField = "Storage";
        }
        Element userAreaElement = XmlWriter.createTagElement(xmlDoc, "userArea");
        CDATASection userFiledText = xmlDoc.createCDATASection(this.userField);
        userAreaElement.appendChild(userFiledText);
        Element senceIntroduceElement = XmlWriter.createTagElement(xmlDoc, "sceneIntroducedialog");
        root.appendChild(userAreaElement);
        root.appendChild(senceIntroduceElement);
        if (null == this.sceneDialogFlag || this.sceneDialogFlag.isEmpty() || "IsTheFirstTime".equals(this.sceneDialogFlag)) {
            this.sceneDialogFlag = "SHOWAGAIN";
        }
        Element sceneShowElement = XmlWriter.createTagElement(xmlDoc, "sceneShow");
        CDATASection sceneShowText = xmlDoc.createCDATASection(this.sceneDialogFlag);
        sceneShowElement.appendChild(sceneShowText);
        if (null == this.userRole || this.userRole.isEmpty()) {
            this.userRole = "EnterPrise";
        }
        Element userTypeElement = XmlWriter.createTagElement(xmlDoc, "userType");
        CDATASection userTypeText = xmlDoc.createCDATASection(this.userRole);
        userTypeElement.appendChild(userTypeText);
        senceIntroduceElement.appendChild(sceneShowElement);
        senceIntroduceElement.appendChild(userTypeElement);
        XmlWriter.writeDomToXmlFile(xmlDoc, pathXMLUserAreaSelected, true);
    }

    public void beginWriteFile(String xmlFileAbsolutePath, File file) {
        if (file.exists() && !file.delete()) {
            LOGGER.error("userRolexml file delete failuer!");
        }
        try {
            if (file.createNewFile()) {
                this.createUserXml(xmlFileAbsolutePath);
            }
        }
        catch (Exception e1) {
            LOGGER.error("create userAreaXml file failuer", (Throwable)e1);
        }
    }

    public String getXmlAbsolutePath() {
        String workpath = ApplicationContext.getInstance().getWorkPath();
        String path = File.separator + "data" + File.separator;
        StringBuilder senceStringBuilder = new StringBuilder();
        senceStringBuilder.append(workpath);
        senceStringBuilder.append(path);
        senceStringBuilder.append(SENCEOPERATE_XML);
        String senceOperateXmlPath = senceStringBuilder.toString();
        return senceOperateXmlPath;
    }

    public String getSupportUser() {
        return this.supportUser;
    }

    public void setSupportUser(String supportUser) {
        this.supportUser = supportUser;
    }

    public String getUserRight() {
        return this.userRight;
    }

    public void setUserRight(String userRight) {
        this.userRight = userRight;
    }

    public boolean isNeedLogin() {
        return this.needLogin;
    }

    public void setNeedLogin(boolean needLogin) {
        this.needLogin = needLogin;
    }

    public void setNetConnectFailed(boolean netConnectFailed) {
        this.netConnectFailed = netConnectFailed;
    }

    public boolean isNetConnectFailed() {
        return this.netConnectFailed;
    }

    public boolean isCustomerImprove() {
        return this.customerImprove;
    }

    public void setCustomerImprove(boolean customerImprove) {
        this.customerImprove = customerImprove;
    }

    public String getConfigurationPath() {
        return this.getWorkPath() + File.separator + "configuration" + File.separator;
    }

    public static boolean isRunInTool() {
        String userDir = ApplicationContext.getInstance().getWorkPath();
        int index = userDir.lastIndexOf(TOOLSFOLDER);
        File iniFile = new File(userDir, "tool.ini");
        return -1 != index && iniFile.exists();
    }

    public static boolean isRunInToolBox() {
        String userDir = ApplicationContext.getInstance().getWorkPath();
        int index = (userDir = Normalizer.normalize(userDir, Normalizer.Form.NFKC)).lastIndexOf(TOOLSFOLDER);
        return -1 == index && !userDir.endsWith(UPDATECHECKER);
    }

    public static String getToolBoxCfgPath() {
        String userDir = ApplicationContext.getInstance().getWorkPath();
        if (ApplicationContext.isRunInTool()) {
            return userDir.substring(0, userDir.lastIndexOf(TOOLSFOLDER)) + "configuration" + File.separator;
        }
        if (ApplicationContext.isRunInToolBox()) {
            return userDir + "configuration" + File.separator;
        }
        return "";
    }

    public String getDefaultCerPath() {
        StringBuffer path = new StringBuffer();
        String currWorkPath = this.getCurrWorkPath();
        String pluginsCfgPath = ApplicationContext.getInstance().getPluginsCfgPath();
        path.append(currWorkPath).append(pluginsCfgPath).append(File.separator).append("defaultCer").append(File.separator);
        LOGGER.info("get default certificate file.");
        return path.toString();
    }

    public String getCurrWorkPath() {
        String userDirs = Normalizer.normalize(ApplicationContext.getInstance().getWorkPath(), Normalizer.Form.NFKC);
        File iniFile = new File(userDirs, "tool.ini");
        File updateFile = new File(userDirs, "updatechecker.exe");
        int index = userDirs.lastIndexOf(TOOLSFOLDER);
        int serverDriversIndex = userDirs.lastIndexOf("drivers");
        if (-1 != serverDriversIndex && iniFile.exists()) {
            userDirs = userDirs.substring(0, serverDriversIndex - 1);
        } else if (-1 != index && iniFile.exists()) {
            LOGGER.info("Tools is getting the toolbox userDir");
            userDirs = userDirs.substring(0, index - 1);
        } else if (userDirs.endsWith(UPDATECHECKER) && updateFile.exists()) {
            LOGGER.info("Updatechecker is getting the toolbox userDir");
            index = userDirs.lastIndexOf(UPDATECHECKER);
            userDirs = userDirs.substring(0, index - 1);
        }
        StringBuilder sbBuilder = new StringBuilder(userDirs);
        sbBuilder.append(File.separator);
        return sbBuilder.toString();
    }

    public synchronized UpdateStatus getUpdateRemindStatus() {
        return this.updateRemindStatus;
    }

    public synchronized void setUpdateRemindStatus(UpdateStatus updateRemindStatus) {
        this.updateRemindStatus = updateRemindStatus;
    }

    public synchronized UpdateStatus getCertificationRemindStatus() {
        return this.certificationRemindStatus;
    }

    public synchronized void setCertificationRemindStatus(UpdateStatus certificationRemindStatus) {
        this.certificationRemindStatus = certificationRemindStatus;
    }

    public boolean isShowActivatingDialog() {
        return this.showActivatingDialog;
    }

    public void setShowActivatingDialog(boolean showActivatingDialog) {
        this.showActivatingDialog = showActivatingDialog;
    }

    public List<IHttpSession> getHttpSessionList() {
        return this.httpSessionList;
    }

    public void closeHttpSession() {
        for (IHttpSession httpSession : this.httpSessionList) {
            httpSession.closeAllSession();
        }
        this.httpSessionList.clear();
    }

    public boolean isOEM() {
        return this.isOEM;
    }

    public String getApplySupportType() {
        return this.applySupportType;
    }

    public void setApplySupportType(String applySupportType) {
        this.applySupportType = applySupportType;
    }

    public void setOEM(boolean oEM) {
        this.isOEM = oEM;
    }

    public boolean isFirstStartBox() {
        boolean res;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getWorkPath()).append(File.separator).append(this.getTmpPath());
        File folder = new File(builder.toString());
        builder.append(File.separator).append("firstStartBoxFlag.xml");
        File file = new File(builder.toString());
        if (file.exists()) {
            return false;
        }
        if (!folder.exists()) {
            res = folder.mkdirs();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file mkdirs is " + res);
            }
        }
        try {
            res = file.createNewFile();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file new create is " + res);
            }
        }
        catch (IOException e) {
            LOGGER.error("create firstStartBoxFlag error");
        }
        return true;
    }

    public boolean isInstallToolbox() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getWorkPath()).append(File.separator).append(this.getTmpPath());
        builder.append(File.separator).append("firstStartBoxFlag.xml");
        File file = new File(builder.toString());
        return file.exists();
    }

    public boolean isToolboxUpdate() {
        return this.toolboxUpdate;
    }

    public void setToolboxUpdate(boolean toolboxUpdate) {
        this.toolboxUpdate = toolboxUpdate;
    }

    public boolean isToolUpdate() {
        return this.toolUpdate;
    }

    public void setToolUpdate(boolean toolUpdate) {
        this.toolUpdate = toolUpdate;
    }

    public void forceToolStopped(String pluginId) {
        AbstractToolBox toolBox = this.getToolContainer();
        if (null != toolBox) {
            LocalHostUtil.killCurrentProcess();
            toolBox.forceToolStopped(pluginId);
        }
    }

    public HookHandler getHookHandler() {
        return this.hookHandler;
    }

    public void setHookHandler(HookHandler hookHandler) {
        this.hookHandler = hookHandler;
    }

    public boolean isPatchUpdate() {
        return this.patchUpdate;
    }

    public void setPatchUpdate(boolean patchUpdate) {
        this.patchUpdate = patchUpdate;
    }

    public String getCurSceneStepName() {
        return this.curSceneStepName;
    }

    public void setCurSceneStepName(String curSceneStepName) {
        this.curSceneStepName = curSceneStepName;
    }

    public void resetCurSceneStepName() {
        this.curSceneStepName = "";
    }

    public INoticeRefresh getNoticePanelInter() {
        return this.noticePanelInter;
    }

    public void setNoticePanelInter(INoticeRefresh noticePanelInter) {
        this.noticePanelInter = noticePanelInter;
    }

    public IStartBsChangeListener getStartBsChangeListener() {
        return this.startBsChangeListener;
    }

    public void setStartBsChangeListener(IStartBsChangeListener startBsChangeListener) {
        this.startBsChangeListener = startBsChangeListener;
    }

    public String getBsLogFilePath() {
        return this.bsLogFilePath;
    }

    public void setBsLogFilePath(String logFilePath) {
        this.bsLogFilePath = logFilePath;
    }

    public boolean isUpgradeFlag() {
        return this.upgradeFlag;
    }

    public void setUpgradeFlag(boolean upgradeFlag) {
        this.upgradeFlag = upgradeFlag;
    }

    public void startUpdateChecker() {
        String startExeCmd = "CMD /C start ";
        StringBuffer updateExepathBuf = new StringBuffer();
        updateExepathBuf.append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append(UPDATECHECKER).append(File.separator).append("updatechecker.exe");
        String updateExepath = updateExepathBuf.toString().replace(" ", "\" \"");
        try {
            String cmdStr = new String((startExeCmd + updateExepath).getBytes(Charset.defaultCharset()), "UTF-8");
            OSCmdUtils.executeCmd(cmdStr);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("faid to start updateChecker", (Throwable)e);
        }
    }

    private String getCurrentUser() {
        return System.getenv("USERNAME").trim();
    }

    private List<String> getAllAvailableUser(String userPath) {
        ArrayList<String> userList = new ArrayList<String>();
        File file = new File(userPath);
        if (this.isExistAllowUsersFile(file)) {
            this.readAllAvailableUser(userList, file);
            return userList;
        }
        return Collections.emptyList();
    }

    public boolean checkUpdatecheckerExist() {
        String path = this.getSmartKitToolPath();
        StringBuffer updatePath = new StringBuffer(path).append(File.separator).append(UPDATECHECKER).append(File.separator).append("updatechecker.exe");
        File updateFile = new File(updatePath.toString());
        return updateFile.exists();
    }

    public void checkCurrentUserUseUpdatechecker() {
        String path = this.getSmartKitToolPath();
        StringBuffer sb = new StringBuffer(path).append(File.separator).append("data").append(File.separator).append("allowUsers.txt");
        String userPath = sb.toString();
        File file = new File(userPath);
        String currentUser = this.getCurrentUser();
        if (this.isCurrentUserStartTool(currentUser)) {
            try {
                List<String> userList;
                if (!this.isExistAllowUsersFile(file)) {
                    file.createNewFile();
                }
                if (!this.isInUsers(currentUser, userList = this.getAllAvailableUser(userPath))) {
                    this.filewrite(currentUser, userPath);
                }
            }
            catch (IOException e) {
                LOGGER.error("create allowUsers file error");
            }
        } else if (!OSCmdUtils.findProcessByName(currentUser, "updatechecker.exe").isEmpty()) {
            LOGGER.info("checking need to kill updatechecker.");
            if (!this.isExistAllowUsersFile(file)) {
                LOGGER.info("this is the first start");
                return;
            }
            List<String> userList = this.getAllAvailableUser(userPath);
            if (!this.isInUsers(currentUser, userList)) {
                LOGGER.info("end updatechecker success");
                System.exit(0);
            }
        }
    }

    public boolean isCurrentUserStartTool(String user) {
        List<String> messageList = OSCmdUtils.findProcessByName(user, "start.exe");
        return !messageList.isEmpty();
    }

    private void filewrite(String str, String path) {
        try (FileWriter writer = new FileWriter(FilePathUtils.getSafePath(path), true);){
            writer.write(str + System.getProperty("line.separator"));
        }
        catch (IOException e) {
            LOGGER.error("write current user to file error");
        }
    }

    private boolean isExistAllowUsersFile(File file) {
        return file.exists();
    }

    private void readAllAvailableUser(List<String> userList, File file) {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
             BufferedReader br = new BufferedReader(isr);){
            String lineTxt;
            while ((lineTxt = br.readLine()) != null) {
                userList.add(lineTxt.trim());
            }
        }
        catch (IOException e) {
            LOGGER.error("read allowUsers.txt error");
        }
    }

    private boolean isInUsers(String currentUser, List<String> userList) {
        boolean flag = false;
        for (String user : userList) {
            if (!user.equals(currentUser)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public String getUploadTempPath(String tempPath) {
        StringBuilder builder = new StringBuilder();
        String uploadTempPath = runtime.getUserTempReturnPath() + tempPath + File.separator;
        File file = new File(uploadTempPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        Date date = new Date();
        String dateStr = DateFormatUtils.format((long)date.getTime(), (String)"yyyyMMddHHmmss");
        builder.append(uploadTempPath);
        builder.append(TOOLBOX);
        builder.append(DateFormatUtils.format((long)date.getTime(), (String)"yyyy-MM-dd"));
        builder.append("_");
        builder.append(this.getCupId() + dateStr);
        builder.append(LOG_STR);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCupId() {
        StringBuffer result;
        block9: {
            result = new StringBuffer();
            String os = this.getOsName();
            if (!StringUtils.isNULLStr(os) && os.startsWith(WINDOWS)) {
                InputStream inputStream = null;
                InputStreamReader streamReader = null;
                BufferedReader input = null;
                Process process = null;
                try {
                    String line;
                    LOGGER.info("process start exec.");
                    process = Runtime.getRuntime().exec(COMMAND);
                    process.getOutputStream().close();
                    inputStream = process.getInputStream();
                    streamReader = new InputStreamReader(inputStream, Charset.defaultCharset());
                    input = new BufferedReader(streamReader);
                    LOGGER.info("process finish exec.");
                    LOGGER.info("get input start.");
                    while ((line = input.readLine()) != null) {
                        if ((line = Normalizer.normalize(line, Normalizer.Form.NFKC)).trim().length() <= 0 || line.contains(PROCESS_ID)) continue;
                        result.append(line);
                    }
                    LOGGER.info("finish to get input start.");
                    StreamUtils.closeStream(null, inputStream);
                }
                catch (IOException e) {
                    LOGGER.error("The file is fail.");
                    break block9;
                }
                finally {
                    StreamUtils.closeStream(null, inputStream);
                    StreamUtils.closeResource(null, streamReader);
                    StreamUtils.closeResource(null, input);
                    if (null != process) {
                        process.destroy();
                    }
                }
                StreamUtils.closeResource(null, streamReader);
                StreamUtils.closeResource(null, input);
                if (null != process) {
                    process.destroy();
                }
            }
        }
        return result.toString().trim();
    }

    private String getOsName() {
        String os = "";
        os = System.getProperty(OS_NAME);
        return os;
    }

    public boolean isValidSign() {
        return this.validSign;
    }

    public void setValidSign(boolean validSign) {
        this.validSign = validSign;
    }

    public boolean isVerifySshHostKeyForStorage() {
        String hostCheck = UserOpDataSaveUtil.getToolBoxIniProp("ssh.should.verify.public.key.strictHostKeyChecking.storage");
        return Boolean.parseBoolean(VerifyUtil.isEmpty(hostCheck) ? "false" : hostCheck.trim());
    }

    public boolean isSftpChannel() {
        String supportChannel = UserOpDataSaveUtil.getSubToolIniProp("ssh.sftp.support.channel");
        return Boolean.parseBoolean(VerifyUtil.isEmpty(supportChannel) ? "false" : supportChannel.trim());
    }

    public BigDecimal getSenceScaleout() {
        BigDecimal scaleout = BigDecimal.ONE;
        String scaleoutEnableConfig = this.getScaloutOrDefaultStr();
        if (scaleoutEnableConfig == null || !"true".equalsIgnoreCase(scaleoutEnableConfig)) {
            return scaleout;
        }
        return this.getSenceScaleoutNum().compareTo(BigDecimal.valueOf(2.0)) > 0 ? BigDecimal.valueOf(1.5) : scaleout;
    }

    public BigDecimal getSenceScaleoutNum() {
        BigDecimal scaleout = BigDecimal.ONE;
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (device.getDisplayMode().getWidth() < 2500) {
            return scaleout;
        }
        int screenDPI = Toolkit.getDefaultToolkit().getScreenResolution();
        return BigDecimal.valueOf(screenDPI).divide(BigDecimal.valueOf(96L), 2, RoundingMode.HALF_UP);
    }

    private String getScaloutOrDefaultStr() {
        try {
            return this.getAppConfig("app.scene.ui.scaleout.enable");
        }
        catch (MissingResourceException e) {
            LOGGER.error("Can't find resource for system.properties, key app.scene.ui.scaleout.enable");
            return "false";
        }
    }

    public List<DeviceMode> getDeviceModeList() {
        return this.deviceModeList;
    }

    public void setDeviceModeList(List<DeviceMode> deviceModeList) {
        this.deviceModeList = deviceModeList;
    }

    public boolean isAgreePrivacyStateFlag() {
        return this.isAgreePrivacyStateFlag;
    }

    public void setAgreePrivacyStateFlag(boolean isAgreePrivacyStateFlag) {
        this.isAgreePrivacyStateFlag = isAgreePrivacyStateFlag;
    }
}

