/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.broker.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.fit.broker.GenericProxyException;
import com.huawei.fit.broker.GenericableInvoker;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.Invoker;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.loadbalance.WorkerFilter;
import com.huawei.fitframework.broker.client.filter.route.AliasFilter;
import com.huawei.fitframework.broker.client.filter.route.PreferRuleFilter;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericableInvoker
implements GenericableInvoker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGenericableInvoker.class);
    private final ProxyFactory proxyFactory;
    private final String genericableId;
    private RouterV2.Filter router;
    private Invoker.Filter filter;
    private final PreferRuleFilter defaultRouter;

    public AbstractGenericableInvoker(ProxyFactory proxyFactory, String genericableId) {
        this.proxyFactory = (ProxyFactory)Validation.notNull((Object)proxyFactory, (String)"The proxy factory of a genericable invoker cannot be null.", (Object[])new Object[0]);
        this.genericableId = Validation.notBlank((String)genericableId, (String)"The id of genericable to invoke cannot be blank.", (Object[])new Object[0]);
        this.defaultRouter = (PreferRuleFilter)this.proxyFactory.getBrokerClient().getProxy(PreferRuleFilter.class);
    }

    protected final ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected final String getGenericableId() {
        return this.genericableId;
    }

    @Override
    public GenericableInvoker setAlias(String alias) {
        this.router = (RouterV2.Filter)StringUtils.mapIfNotBlank((String)alias, xva$0 -> new AliasFilter(new String[]{xva$0}));
        return this;
    }

    @Override
    public GenericableInvoker setWorker(String workerId) {
        this.filter = (Invoker.Filter)StringUtils.mapIfNotBlank((String)workerId, WorkerFilter::new);
        return this;
    }

    @Override
    public String invoke(String requestJson, InvokeContext context) {
        Object response = this.getRouter().route((RouterV2.Filter)ObjectUtils.nullIf((Object)this.router, (Object)this.defaultRouter)).filter((Invoker.Filter)ObjectUtils.nullIf((Object)this.filter, (Object)Invoker.Filter.empty())).context(context).invoke(this.parseArguments(requestJson));
        return this.emitResponse(response);
    }

    private Object[] parseArguments(String requestJson) {
        JsonNode json;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.readTree(requestJson);
        }
        catch (JsonProcessingException e) {
            log.error("The request is not a valid JSON string. [request={}]", (Object)requestJson);
            throw new GenericProxyException(2130837763);
        }
        return this.parseArguments(mapper, json);
    }

    protected abstract RouterV2 getRouter();

    protected abstract Object[] parseArguments(ObjectMapper var1, JsonNode var2);

    protected abstract String emitResponse(Object var1);
}

