/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.broker.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.fit.broker.GenericProxyException;
import com.huawei.fit.broker.support.AbstractGenericableInvoker;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenericableInvoker
extends AbstractGenericableInvoker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGenericableInvoker.class);
    private final Class<?> genericableClass;

    public DefaultGenericableInvoker(ProxyFactory proxyFactory, String genericableId) {
        super(proxyFactory, genericableId);
        this.genericableClass = this.getProxyFactory().getGenericableClass(genericableId);
    }

    @Override
    protected RouterV2 getRouter() {
        return this.getProxyFactory().getBrokerClient().get(this.genericableClass);
    }

    @Override
    protected Object[] parseArguments(ObjectMapper mapper, JsonNode requestJson) {
        List parameters = Optional.ofNullable(this.genericableClass).map(ReflectionUtils::getDeclaredMethods).map(Stream::of).orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"Genericable class not found. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()}))).filter(method -> StringUtils.equals((String)method.getName(), (String)"process")).map(Executable::getParameters).map(Arrays::asList).findAny().orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No 'process' method found. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()})));
        Object[] args = new Object[parameters.size()];
        for (int i = 0; i < args.length; ++i) {
            if (i >= requestJson.size()) continue;
            JsonNode arg = requestJson.get(i);
            args[i] = mapper.convertValue((Object)arg, mapper.constructType(((Parameter)parameters.get(i)).getParameterizedType()));
        }
        return args;
    }

    @Override
    protected String emitResponse(Object response) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(response);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to emit JSON string by response.");
            throw new GenericProxyException(2130837764);
        }
    }
}

