/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.server.server;

import com.huawei.fit.broker.server.entity.FileDescriptor;
import com.huawei.fit.hakuna.kernel.broker.client.GenericDownload;
import com.huawei.fit.hakuna.kernel.broker.client.GenericInvokeV2;
import com.huawei.fit.hakuna.kernel.broker.client.entity.GenericInvokeContext;
import com.huawei.fit.hakuna.system.shared.entity.StringResponse;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.route.AliasFilter;
import com.huawei.fitframework.broker.client.filter.route.PreferRuleFilter;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.serialization.SerializationException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class GenericProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericProxy.class);
    private static final String GENERICABLE_RESOURCE_PREFIX = "fit.public.genericables.";
    private final ProxyFactory proxyFactory;
    private final JsonSerializer jsonSerializer;
    private final ConfigCenterClient configCenterClient;
    private final ConfigurationLoader configurationLoader;
    private final ConfigCenterListener configCenterListener;
    private final String appName;
    private final PreferRuleFilter preferRuleFilter;

    public GenericProxy(ProxyFactory proxyFactory, JsonSerializer jsonSerializer, ConfigCenterClient configCenterClient, ConfigurationLoader configurationLoader, ConfigCenterListener configCenterListener, @Value(value="${app.name}") String appName, @Fit PreferRuleFilter preferRuleFilter) {
        this.proxyFactory = proxyFactory;
        this.jsonSerializer = jsonSerializer;
        this.configCenterClient = configCenterClient;
        this.configurationLoader = configurationLoader;
        this.configCenterListener = configCenterListener;
        this.appName = appName;
        this.preferRuleFilter = preferRuleFilter;
    }

    @Fitable(generic=GenericInvokeV2.class, id="344e4b1e534a4517abf3d2c4383e134c")
    public StringResponse genericInvokeV2(GenericInvokeContext context) throws Throwable {
        String genericableId = context.getGenericableId();
        Validation.notBlank((String)genericableId, (String)"No genericableId.", (Object[])new Object[0]);
        try {
            this.prepareConfiguration(genericableId);
            log.debug(StringUtils.format((String)"Method genericInvokeV2 is called. [genericableId={0}]", (Object[])new Object[]{genericableId}));
            InvokeContext invokeContext = this.getInvokeContext(context);
            Object[] args = this.getArgs(genericableId, context.getParams());
            Object result = this.invoke(context.getAlias(), context.getWorkerId(), genericableId, invokeContext, args);
            return this.convert2GenericResponse(genericableId, result);
        }
        catch (MethodInvocationException ex) {
            throw this.handleMethodInvocationException(ex);
        }
    }

    @Fitable(generic=GenericDownload.class, id="1966bd1a69dc4c8ea350da09f81a4bef")
    public FileDescriptor genericDownload(GenericInvokeContext context) throws Throwable {
        String genericableId = context.getGenericableId();
        Validation.notBlank((String)genericableId, (String)"No genericableId.", (Object[])new Object[0]);
        try {
            this.prepareConfiguration(genericableId);
            InvokeContext invokeContext = this.getInvokeContext(context);
            Object[] args = this.getArgs(genericableId, context.getParams());
            Object result = this.invoke(context.getAlias(), context.getWorkerId(), genericableId, invokeContext, args);
            result = this.deserializeToFileForGenericInvoke(genericableId, result);
            Validation.isTrue((boolean)(result instanceof FileDescriptor), (String)"Return type of genericable[{0}] is not FileDescriptor, cannot download.", (Object[])new Object[]{genericableId});
            return (FileDescriptor)result;
        }
        catch (MethodInvocationException ex) {
            throw this.handleMethodInvocationException(ex);
        }
    }

    private StringResponse convert2GenericResponse(String genericableId, Object result) {
        if (!this.isGenericableOnLocal(genericableId)) {
            return StringResponse.builder().isRawString(Boolean.valueOf(false)).data((String)result).build();
        }
        if (result instanceof String) {
            return StringResponse.builder().isRawString(Boolean.valueOf(true)).data((String)result).build();
        }
        return StringResponse.builder().isRawString(Boolean.valueOf(false)).data(this.jsonSerializer.serialize(result)).build();
    }

    private Object invoke(String alias, String workerId, String genericableId, InvokeContext invokeContext, Object[] args) {
        BrokerClient brokerClient = this.proxyFactory.getBrokerClient();
        RouterV2 router = this.isGenericableOnLocal(genericableId) ? brokerClient.get(this.proxyFactory.getGenericableClass(genericableId)) : brokerClient.get4GenericInvoke(genericableId);
        return router.route((RouterV2.Filter)(StringUtils.isNotBlank((String)alias) ? new AliasFilter(new String[]{alias}) : this.preferRuleFilter)).filter((fitable, localWorkerId, toFilterTargets) -> {
            if (StringUtils.isBlank((String)workerId)) {
                return toFilterTargets;
            }
            return toFilterTargets.stream().filter(toFilterTarget -> Objects.equals(toFilterTarget.getWorkerId(), workerId)).collect(Collectors.toList());
        }).context(invokeContext).invoke(args);
    }

    private Object deserializeToFileForGenericInvoke(String genericableId, Object result) {
        if (this.isGenericableOnLocal(genericableId)) {
            return result;
        }
        if (result instanceof String) {
            return this.jsonSerializer.deserialize((String)result, FileDescriptor.class);
        }
        throw new FitException("invalid result type in generic download. [genericableId=" + genericableId + "]");
    }

    private boolean isGenericableOnLocal(String genericableId) {
        return this.proxyFactory.contains(genericableId);
    }

    private boolean containsGenericable(String genericableId) {
        Optional genericable = this.configurationLoader.load().genericable(genericableId);
        return genericable.isPresent() && CollectionUtils.isNotEmpty((Collection)((GenericableConfiguration)genericable.get()).fitables());
    }

    private void prepareConfiguration(String genericableId) {
        if (this.containsGenericable(genericableId)) {
            return;
        }
        String configPath = GENERICABLE_RESOURCE_PREFIX + genericableId;
        this.configCenterClient.subscribe(StringUtils.format((String)"{0}:genericables", (Object[])new Object[]{this.appName}), configPath);
        this.configCenterClient.download(configPath, (arg_0, arg_1) -> ((ConfigCenterListener)this.configCenterListener).onPropertiesChanged(arg_0, arg_1));
    }

    private List<Parameter> getParameters(String genericableId) {
        Class genericableClass = this.proxyFactory.getGenericableClass(genericableId);
        Method processMethod = Arrays.stream(ReflectionUtils.getDeclaredMethods((Class)genericableClass)).filter(method -> StringUtils.equals((String)method.getName(), (String)"process")).findFirst().orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No 'process' method found. [genericableId={0}]", (Object[])new Object[]{genericableClass})));
        Parameter[] parameters = processMethod.getParameters();
        return Stream.of(parameters).collect(Collectors.toList());
    }

    private Throwable handleMethodInvocationException(MethodInvocationException methodInvocationException) {
        Throwable cause;
        MethodInvocationException currentException = methodInvocationException;
        while ((cause = currentException.getCause()) instanceof MethodInvocationException && cause != currentException) {
            currentException = (MethodInvocationException)cause;
        }
        return cause;
    }

    private Object[] getArgs(String genericableId, List<String> params) {
        if (!this.isGenericableOnLocal(genericableId)) {
            return params.stream().map(value -> value).toArray();
        }
        List actualParams = (List)ObjectUtils.nullIf(params, Collections.emptyList());
        List<Parameter> parameters = this.getParameters(genericableId);
        return this.convertParams(actualParams, parameters.stream().map(Parameter::getParameterizedType).collect(Collectors.toList()));
    }

    private Object[] convertParams(List<String> params, List<Type> parameterTypes) {
        int len = parameterTypes.size();
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            String paramValue = params.size() <= i ? null : (params.get(i) == null ? null : params.get(i));
            args[i] = this.convertParam(paramValue, parameterTypes.get(i));
        }
        return args;
    }

    private Object convertParam(String value, Type type) {
        try {
            return Optional.ofNullable(value).map(actualValue -> this.jsonSerializer.deserialize(actualValue, type)).orElse(null);
        }
        catch (SerializationException e) {
            throw new FitException(StringUtils.format((String)"Fail to convert param. [param={0}, expectedType={1}]", (Object[])new Object[]{value, type.getTypeName()}), (Throwable)e);
        }
    }

    private InvokeContext getInvokeContext(GenericInvokeContext genericInvokeContext) {
        return InvokeContext.builder().timeout(genericInvokeContext.getTimeout()).retry(Integer.valueOf(((Long)ObjectUtils.nullIf((Object)genericInvokeContext.getRetry(), (Object)0L)).intValue())).build();
    }
}

