/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.JetStreamOptions;
import java.time.Duration;

public class KeyValueOptions {
    private final JetStreamOptions jso;

    private KeyValueOptions(JetStreamOptions jso) {
        this.jso = jso;
    }

    public JetStreamOptions getJetStreamOptions() {
        return this.jso;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KeyValueOptions kvo) {
        return new Builder(kvo);
    }

    public static Builder builder(JetStreamOptions jso) {
        return new Builder().jetStreamOptions(jso);
    }

    public static class Builder {
        private JetStreamOptions.Builder jsoBuilder;

        public Builder() {
            this(null);
        }

        public Builder(KeyValueOptions kvo) {
            this.jsoBuilder = kvo == null ? new JetStreamOptions.Builder() : new JetStreamOptions.Builder(kvo.jso);
        }

        public Builder jetStreamOptions(JetStreamOptions jso) {
            this.jsoBuilder = new JetStreamOptions.Builder(jso);
            return this;
        }

        public Builder jsRequestTimeout(Duration requestTimeout) {
            this.jsoBuilder.requestTimeout(requestTimeout);
            return this;
        }

        public Builder jsPrefix(String prefix) {
            this.jsoBuilder.prefix(prefix);
            return this;
        }

        public Builder jsDomain(String domain) {
            this.jsoBuilder.domain(domain);
            return this;
        }

        public KeyValueOptions build() {
            return new KeyValueOptions(this.jsoBuilder.build());
        }
    }
}

