/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.huawei.fit.hakuna.kernel.registry.listener.AddFitableListener;
import com.huawei.fit.hakuna.kernel.registry.listener.GetFitableAddresses;
import com.huawei.fit.hakuna.kernel.registry.listener.MarkFitableAddressStatus;
import com.huawei.fit.hakuna.kernel.registry.listener.RemoveFitableListener;
import com.huawei.fit.hakuna.kernel.registry.server.NotifyFitables;
import com.huawei.fit.hakuna.kernel.registry.server.QueryFitablesAddresses;
import com.huawei.fit.hakuna.kernel.registry.server.SubscribeFitables;
import com.huawei.fit.hakuna.kernel.registry.server.UnsubscribeFitables;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.registry.registry.LocalFitableCache;
import com.huawei.fitframework.registry.registry.RegistryListenMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class RegistryListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryListener.class);
    private static final String NOTIFY_FITABLE_ID = "347fd33f3cde4aa891614a9e244ae5e8";
    private static final long INITIAL_DELAY = 10L;
    private static final String REGISTRY_LISTENER_THREAD_NAME = "registry-listener";
    private final QueryFitablesAddresses queryFitablesAddresses;
    private final UnsubscribeFitables unsubscribeFitables;
    private final SubscribeFitables subscribeFitables;
    private final LoadingCache<FitableKey, FitableInstance> fitableInstancesCache;
    private final Cache<String, Worker> invalidAddressCache;
    private final LocalFitableCache localFitableCache;
    private final RegistryListenMode registryListenMode;
    private final String workerId;
    private final String environment;
    private final Long registryPullPeriod;
    private final ScheduledExecutorService scheduleExecutor;

    public RegistryListener(@Fit QueryFitablesAddresses queryFitablesAddresses, @Fit SubscribeFitables subscribeFitables, @Fit UnsubscribeFitables unsubscribeFitables, LocalFitableCache localFitableCache, @Value(value="${server.id}") String workerId, @Value(value="${worker.environment}") String environment, @Value(value="${plugin.registry.listener.cache.service-address.max}") Integer max, @Value(value="${plugin.registry.listener.cache.invalid-service-address.expire-time}") Integer expiredIn, @Value(value="${plugin.registry.listener.mode}") String registryListenMode, @Value(value="${plugin.registry.listener.pull.period}") Long period) {
        this.queryFitablesAddresses = queryFitablesAddresses;
        this.subscribeFitables = subscribeFitables;
        this.unsubscribeFitables = unsubscribeFitables;
        this.localFitableCache = localFitableCache;
        this.workerId = Validation.notBlank((String)workerId, (String)"No worker id.", (Object[])new Object[0]);
        this.environment = Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        log.info("Config worker.environment is {}.", (Object)this.environment);
        int maxServiceCache = this.getMaxServiceCache(max);
        log.info("Max number of service address cache is {}.", (Object)maxServiceCache);
        int expiredInOfInvaliServiceCache = this.getExpiredTimeOfInvalidServiceCache(expiredIn);
        log.info("Expired time of invalid service address cache is {} second.", (Object)expiredInOfInvaliServiceCache);
        this.registryListenMode = this.getRegistryListenMode(registryListenMode);
        log.info("Registry listen mode is {}.", (Object)this.registryListenMode.name());
        this.registryPullPeriod = this.getRegistryPullPeriod(period);
        log.info("Registry pull period is {} second.", (Object)this.registryPullPeriod);
        this.fitableInstancesCache = Caffeine.newBuilder().maximumSize((long)maxServiceCache).removalListener(this::onFitableCacheRemoval).build(this::loadFitableInstance);
        this.invalidAddressCache = Caffeine.newBuilder().maximumSize((long)maxServiceCache).softValues().expireAfterWrite((long)expiredInOfInvaliServiceCache, TimeUnit.SECONDS).build();
        this.scheduleExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> log.error("uncaught exception. [threadName={}, exception={}]", (Object)thread1.getName(), (Object)throwable.getMessage()));
            thread.setDaemon(true);
            thread.setName(REGISTRY_LISTENER_THREAD_NAME);
            return thread;
        });
    }

    private int getMaxServiceCache(Integer maxServiceCache) {
        Validation.notNull((Object)maxServiceCache, (String)"No max number of service address cache. [config=plugin.registry.listener.cache.service-address.max]", (Object[])new Object[0]);
        return Validation.greaterThan((int)maxServiceCache, (int)0, (String)"Max number of service address cache must be positive. [plugin.registry.listener.cache.service-address.max={0}]", (Object[])new Object[]{maxServiceCache});
    }

    private int getExpiredTimeOfInvalidServiceCache(Integer expiredInOfInvalidServiceCache) {
        Validation.notNull((Object)expiredInOfInvalidServiceCache, (String)"No expired time of invalid service address cache. [config=plugin.registry.listener.cache.invalid-service-address.expire-time]", (Object[])new Object[0]);
        return Validation.greaterThan((int)expiredInOfInvalidServiceCache, (int)0, (String)"Expired time of invalid service address cache must be positive. [plugin.registry.listener.cache.invalid-service-address.expire-time={0}]", (Object[])new Object[]{expiredInOfInvalidServiceCache});
    }

    private RegistryListenMode getRegistryListenMode(String registryListenMode) {
        RegistryListenMode mode = RegistryListenMode.fromMode(registryListenMode);
        if (mode == null) {
            log.warn("No registry listen mode, use default mode instead. [registryListenMode={}, defaultMode={}]", (Object)registryListenMode, (Object)RegistryListenMode.PULL_AND_PUSH.name());
        }
        return (RegistryListenMode)((Object)ObjectUtils.nullIf((Object)((Object)mode), (Object)((Object)RegistryListenMode.PULL_AND_PUSH)));
    }

    private long getRegistryPullPeriod(Long pullPeriod) {
        Validation.notNull((Object)pullPeriod, (String)"No pull period. [config=plugin.registry.listener.pull.period]", (Object[])new Object[0]);
        return Validation.greaterThan((long)pullPeriod, (long)0L, (String)"Pull period must be positive. [plugin.registry.listener.pull.period={0}]", (Object[])new Object[]{pullPeriod});
    }

    @PostConstruct
    public void init() {
        if (this.registryListenMode.pullModeEnabled()) {
            log.info(StringUtils.format((String)"Start scheduled task to sync fitable addresses. [initDelay={0} seconds, period={1} seconds]", (Object[])new Object[]{10L, this.registryPullPeriod}));
            this.scheduleExecutor.scheduleAtFixedRate(this::syncListeners, 10L, this.registryPullPeriod, TimeUnit.SECONDS);
        } else {
            log.info("Not start scheduled task to sync fitable addresses, because pull mode not enabled.");
        }
    }

    @com.huawei.fitframework.annotation.Fitable(generic=AddFitableListener.class, id="b79789805656420cb323e4df0a6f48b1")
    public void addFitableListener(List<Fitable> fitables) {
        if (CollectionUtils.isEmpty(fitables)) {
            return;
        }
        fitables.stream().filter(Objects::nonNull).map(x$0 -> new FitableKey((Fitable)x$0)).filter(fitableKey -> !this.fitableInstancesCache.asMap().containsKey(fitableKey)).forEach(arg_0 -> this.fitableInstancesCache.refresh(arg_0));
    }

    @com.huawei.fitframework.annotation.Fitable(generic=RemoveFitableListener.class, id="f002e79313994ae6b9c6e98f7ba0d3eb")
    public void removeFitableListener(List<Fitable> fitables) {
        if (CollectionUtils.isEmpty(fitables)) {
            return;
        }
        fitables.stream().filter(Objects::nonNull).map(x$0 -> new FitableKey((Fitable)x$0)).filter(this.fitableInstancesCache.asMap()::containsKey).forEach(arg_0 -> this.fitableInstancesCache.invalidate(arg_0));
    }

    @com.huawei.fitframework.annotation.Fitable(generic=GetFitableAddresses.class, id="2594fdb0d3994eb789eebf8a2f37556c")
    public FitableInstance getFitableAddresses(Fitable fitable) {
        FitableInstance fitableInstance = (FitableInstance)this.fitableInstancesCache.get((Object)new FitableKey(fitable));
        if (fitableInstance == null) {
            fitableInstance = FitableInstance.builder().applicationInstances(new ArrayList()).build();
            log.debug("No instance in cache. [fitable={}]", (Object)fitable);
        } else {
            List validInstances = fitableInstance.getApplicationInstances().stream().filter(Objects::nonNull).map(applicationInstance -> this.toValidApplicationInstance((ApplicationInstance)applicationInstance, fitable)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            fitableInstance.setApplicationInstances(validInstances);
            log.debug("Get valid instance from cache. [fitable={}, instance={}]", (Object)fitable, (Object)fitableInstance);
        }
        BundleIdentity target = new BundleIdentity(fitable.getGenericableId(), fitable.getFitableId());
        if (this.localFitableCache.getLocalFitables().contains(target) && !this.isExistInFitableInstance(fitableInstance)) {
            Worker worker = Worker.builder().id(this.workerId).environment(this.environment).build();
            ApplicationInstance localInstance = ApplicationInstance.builder().workers(Collections.singletonList(worker)).build();
            fitableInstance.getApplicationInstances().add(localInstance);
        }
        return fitableInstance;
    }

    private boolean isExistInFitableInstance(FitableInstance fitableInstance) {
        return fitableInstance.getApplicationInstances().stream().flatMap(applicationInstance -> applicationInstance.getWorkers().stream()).anyMatch(worker -> Objects.equals(worker.getId(), this.workerId) && Objects.equals(worker.getEnvironment(), this.environment));
    }

    private Optional<ApplicationInstance> toValidApplicationInstance(ApplicationInstance applicationInstance, Fitable fitable) {
        if (CollectionUtils.isEmpty((Collection)applicationInstance.getWorkers())) {
            return Optional.empty();
        }
        List workers = applicationInstance.getWorkers().stream().filter(Objects::nonNull).filter(worker -> this.isValid(fitable.getFitableId(), worker.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workers)) {
            return Optional.empty();
        }
        applicationInstance.setWorkers(workers);
        return Optional.of(applicationInstance);
    }

    private boolean isValid(String fitableId, String workerId) {
        return !this.invalidAddressCache.asMap().containsKey(this.buildInvalidCacheKey(fitableId, workerId));
    }

    @com.huawei.fitframework.annotation.Fitable(generic=NotifyFitables.class, id="347fd33f3cde4aa891614a9e244ae5e8")
    public void notifyFitables(List<FitableInstance> fitableInstances) {
        if (CollectionUtils.isEmpty(fitableInstances)) {
            log.info("Received latest fitable instances, but ignored: no data.");
            return;
        }
        List<FitableInstance> validFitableAddresses = this.filterServiceAddresses(fitableInstances);
        log.info("Validate received fitable addresses. [receivedSize={}, validSize={}]", (Object)fitableInstances.size(), (Object)validFitableAddresses.size());
        this.updateFitableInstancesCache(validFitableAddresses);
    }

    @com.huawei.fitframework.annotation.Fitable(generic=MarkFitableAddressStatus.class, id="973427d57eba42df8bd40d5eab7c5315")
    public void markFitableAddressStatus(Fitable fitable, Worker worker, Boolean valid) {
        String invalidCacheKey = this.buildInvalidCacheKey(fitable.getFitableId(), worker.getId());
        if (Boolean.TRUE.equals(valid)) {
            this.invalidAddressCache.invalidate((Object)invalidCacheKey);
        } else {
            this.invalidAddressCache.put((Object)invalidCacheKey, (Object)worker);
        }
    }

    private String buildInvalidCacheKey(String fitableId, String workerId) {
        return fitableId + workerId;
    }

    private FitableInstance loadFitableInstance(FitableKey fitableKey) {
        Fitable fitable = fitableKey.toFitable();
        List<FitableInstance> fitableInstances = this.registryListenMode.pushModeEnabled() ? this.subscribe(fitable) : this.queryFitableInstances(Collections.singleton(fitable));
        if (CollectionUtils.isEmpty(fitableInstances)) {
            log.warn("No fitable instance loaded from registry. [genericableId={}, fitableId={}]", (Object)fitable.getGenericableId(), (Object)fitable.getFitableId());
            return null;
        }
        Validation.lessThanOrEquals((int)fitableInstances.size(), (int)1, (String)"Get more than 1 fitable instances. [genericableId={0}, genericableVersion={1}, fitableId={2}]", (Object[])new Object[]{fitable.getGenericableId(), fitable.getGenericableVersion(), fitable.getFitableId()});
        log.debug("Load fitable instance from registry. [genericableId={}, fitableId={}, fitableInstanceSize={}, fitableInstances={}]", new Object[]{fitable.getGenericableId(), fitable.getFitableId(), fitableInstances.size(), fitableInstances});
        return fitableInstances.get(0);
    }

    private List<FitableInstance> subscribe(Fitable fitable) {
        try {
            log.debug("Prepare to subscribe fitable instances. [fitable={}]", (Object)fitable);
            List instances = this.subscribeFitables.process(Collections.singletonList(fitable), this.workerId, NOTIFY_FITABLE_ID);
            log.debug("Subscribe fitable instances successfully. [fitable={}]", (Object)fitable);
            return instances;
        }
        catch (Exception e) {
            log.warn("Fail to subscribe fitable instances. [fitable={}]", (Object)fitable);
            log.debug("Fail to subscribe fitable instances.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void syncListeners() {
        Set<Fitable> cachedFitables = this.fitableInstancesCache.asMap().keySet().stream().map(rec$ -> ((FitableKey)rec$).toFitable()).collect(Collectors.toSet());
        List<FitableInstance> fitableInstances = this.queryFitableInstances(cachedFitables);
        this.updateFitableInstancesCache(fitableInstances);
    }

    private List<FitableInstance> queryFitableInstances(Set<Fitable> fitables) {
        try {
            log.debug("Prepare to query fitable instances. [fitables={}]", fitables);
            List instances = this.queryFitablesAddresses.process(new ArrayList<Fitable>(fitables), this.workerId);
            log.debug("Query fitable instances successfully. [fitables={}]", fitables);
            return instances;
        }
        catch (Exception e) {
            log.warn("Fail to query fitable instances. [fitables={}]", fitables);
            log.debug("Fail to query fitable instances.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void updateFitableInstancesCache(List<FitableInstance> fitableInstances) {
        fitableInstances.stream().filter(fitableInstance -> this.fitableInstancesCache.asMap().containsKey(new FitableKey(fitableInstance.getFitable()))).forEach(this::updateFitableInstancesCache);
    }

    private void updateFitableInstancesCache(FitableInstance fitableInstance) {
        FitableKey fitableKey = new FitableKey(fitableInstance.getFitable());
        this.fitableInstancesCache.put((Object)fitableKey, (Object)fitableInstance);
    }

    private List<FitableInstance> filterServiceAddresses(List<FitableInstance> serviceAddresses) {
        return serviceAddresses.stream().filter(Objects::nonNull).filter(serviceAddress -> serviceAddress.getFitable() != null).collect(Collectors.toList());
    }

    private void onFitableCacheRemoval(Object fitable, Object instance, RemovalCause cause) {
        if (!(fitable instanceof FitableKey)) {
            log.warn("Object type is not FitableKey when intending to remove from cache. [Object={}]", fitable);
            return;
        }
        if (cause == RemovalCause.EXPLICIT) {
            this.unsubscribe(Collections.singletonList(((FitableKey)fitable).toFitable()));
        }
    }

    private void unsubscribe(Collection<Fitable> fitables) {
        try {
            log.debug("Prepare to unsubscribe fitables. [fitables={}]", fitables);
            this.unsubscribeFitables.process(new ArrayList<Fitable>(fitables), this.workerId, NOTIFY_FITABLE_ID);
            log.debug("Unsubscribe fitables successfully. [fitables={}]", fitables);
        }
        catch (FitException e) {
            log.warn("Fail to unsubscribe fitables. [fitables={}]", fitables);
            log.debug("Fail to unsubscribe fitables.", (Throwable)e);
        }
        fitables.forEach(unsubscribeFailedFitable -> this.unsubscribeFitables.process(Collections.singletonList(unsubscribeFailedFitable), this.workerId, NOTIFY_FITABLE_ID));
    }

    private static class FitableKey {
        private final String genericId;
        private final String genericVersion;
        private final String fitId;

        private FitableKey(Fitable fitable) {
            this.genericId = fitable.getGenericableId();
            this.genericVersion = fitable.getGenericableVersion();
            this.fitId = fitable.getFitableId();
        }

        private Fitable toFitable() {
            return Fitable.builder().genericableId(this.genericId).genericableVersion(this.genericVersion).fitableId(this.fitId).build();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FitableKey)) {
                return false;
            }
            FitableKey other = (FitableKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$genericId = this.genericId;
            String other$genericId = other.genericId;
            if (this$genericId == null ? other$genericId != null : !this$genericId.equals(other$genericId)) {
                return false;
            }
            String this$genericVersion = this.genericVersion;
            String other$genericVersion = other.genericVersion;
            if (this$genericVersion == null ? other$genericVersion != null : !this$genericVersion.equals(other$genericVersion)) {
                return false;
            }
            String this$fitId = this.fitId;
            String other$fitId = other.fitId;
            return !(this$fitId == null ? other$fitId != null : !this$fitId.equals(other$fitId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FitableKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $genericId = this.genericId;
            result = result * 59 + ($genericId == null ? 43 : $genericId.hashCode());
            String $genericVersion = this.genericVersion;
            result = result * 59 + ($genericVersion == null ? 43 : $genericVersion.hashCode());
            String $fitId = this.fitId;
            result = result * 59 + ($fitId == null ? 43 : $fitId.hashCode());
            return result;
        }
    }
}

