/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.registry.registry.LocalFitableCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

@Fitable
public class DefaultLocalFitableCache
implements LocalFitableCache {
    private final ReadWriteLock lock = LockUtils.newReentrantReadWriteLock();
    private final List<BundleIdentity> localFitables = new ArrayList<BundleIdentity>();

    @Override
    public void addLocalFitables(List<BundleIdentity> localFitables) {
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> this.localFitables.addAll(localFitables));
    }

    @Override
    public List<BundleIdentity> getLocalFitables() {
        return (List)LockUtils.synchronize((Lock)this.lock.readLock(), () -> Collections.unmodifiableList(this.localFitables));
    }
}

