/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.serialization.json.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.serialization.SerializationException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class JacksonSerializer
implements JsonSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public String serialize(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException(StringUtils.format((String)"Fail to serialize [{0}] to [String].", (Object[])new Object[]{object}), (Throwable)ex);
        }
    }

    public <T> T deserialize(String data, Type dataClass) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        Validation.notNull((Object)dataClass, () -> new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}], data class is null.", (Object[])new Object[]{data})));
        try {
            JavaType javaType = this.mapper.constructType(dataClass);
            return (T)this.mapper.readValue(data, javaType);
        }
        catch (IOException ex) {
            throw new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}] to [{1}].", (Object[])new Object[]{data, dataClass.getTypeName()}), (Throwable)ex);
        }
    }

    public Map<String, Object> deserialize2Map(String data) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        try {
            return (Map)this.mapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException ex) {
            throw new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}] to [Map<String, Object>].", (Object[])new Object[]{data}), (Throwable)ex);
        }
    }

    public <T> List<T> deserialize2List(String data, final Type dataClass) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        Validation.notNull((Object)dataClass, () -> new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}] to [List], data class is null.", (Object[])new Object[]{data})));
        try {
            JavaType javaType = this.mapper.constructType((Type)new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{dataClass};
                }

                @Override
                public Type getRawType() {
                    return List.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            });
            return (List)this.mapper.readValue(data, javaType);
        }
        catch (IOException ex) {
            throw new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}] to [List<{1}>].", (Object[])new Object[]{data, dataClass.getTypeName()}), (Throwable)ex);
        }
    }

    public List<Object> deserialize2List(String data) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        try {
            return (List)this.mapper.readValue(data, (TypeReference)new TypeReference<List<Object>>(){});
        }
        catch (IOException ex) {
            throw new SerializationException(StringUtils.format((String)"Fail to deserialize [{0}] to [List<Object>].", (Object[])new Object[]{data}), (Throwable)ex);
        }
    }
}

