/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.config;

import com.huawei.fit.plugin.gateway.config.HttpConfig;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Fitable
public class DefaultHttpConfig
implements HttpConfig {
    private static final String EXTENSION_SEPARATOR = ",";
    private static final String EXTENSION_ALL = "*";
    private final List<String> extensionList;

    public DefaultHttpConfig(@Value(value="${server.allowed.post-ext-list}") String extensions) {
        this.extensionList = this.getExtensionList(extensions);
    }

    private List<String> getExtensionList(String extensions) {
        if (StringUtils.isBlank((String)extensions)) {
            return Collections.singletonList(EXTENSION_ALL);
        }
        return Stream.of(extensions.split(EXTENSION_SEPARATOR)).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllowedPostExtensionList() {
        return Collections.unmodifiableList(this.extensionList);
    }
}

