/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.config;

import com.huawei.fit.plugin.gateway.config.entity.LoadBalanceConfig;
import com.huawei.fit.plugin.gateway.config.entity.LoadBalanceGenericableConfig;
import com.huawei.fitframework.broker.conf.util.ValueUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalanceConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadBalanceConfigurator.class);
    private static final String LOAD_BALANCE_KEY = "load-balance";
    private final Map<String, Object> values;
    private final File file;

    public LoadBalanceConfigurator(Map<String, Object> values, File file) {
        this.values = values;
        this.file = file;
    }

    public Set<String> configure(LoadBalanceConfig config) {
        Map genericables = (Map)ValueUtils.cast((Object)this.values.get("genericables"));
        if (genericables == null) {
            log.debug("Incorrect format of load balance config file: no 'genericables' key prefix. [path={}, format=genericables.${genericableId}.load-balance=${load-balance-fitable-id}]", (Object)FileUtils.path((File)this.file));
            return Collections.emptySet();
        }
        genericables.forEach((genericableId, value) -> this.configGenericable(config, (String)genericableId, (Map)ValueUtils.cast((Object)value)));
        return genericables.keySet();
    }

    private void configGenericable(LoadBalanceConfig config, String genericableId, Map<String, Object> values) {
        LoadBalanceGenericableConfig loadBalanceGenericableConfig = config.getOrCreateGenericable(genericableId);
        if (!values.containsKey(LOAD_BALANCE_KEY)) {
            log.warn("Incorrect format of load balance config file: no 'load-balance' sub-key. [genericableId={}, path={}, format=genericables.${genericableId}.load-balance=${load-balance-fitable-id}]", (Object)genericableId, (Object)FileUtils.path((File)this.file));
            return;
        }
        loadBalanceGenericableConfig.setLoadBalance(ValueUtils.stringValue(values, (String)LOAD_BALANCE_KEY, null));
    }

    @Generated
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

