/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.config.loaders;

import com.huawei.fit.plugin.gateway.config.LoadBalanceConfigLoader;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.core.common.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLoadBalanceConfigLoader
implements LoadBalanceConfigLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarLoadBalanceConfigLoader.class);
    private final File jar;
    private final String resource;
    private final ConfigurationReader reader;

    public JarLoadBalanceConfigLoader(File jar, String resource, ConfigurationReader reader) {
        this.jar = jar;
        this.resource = resource;
        this.reader = reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> read() {
        try (JarFile jarFile = new JarFile(this.jar);){
            Map<String, Object> map = this.read(jarFile);
            return map;
        }
        catch (IOException e) {
            log.warn("Fail to read load balance config from JAR entry. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resource);
            log.debug("Fail to read load balance config from JAR entry.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, Object> read(JarFile jarFile) throws IOException {
        ZipEntry entry = jarFile.getEntry(this.resource);
        if (entry == null) {
            log.debug("Entry not found in JAR. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resource);
            return Collections.emptyMap();
        }
        if (entry.isDirectory()) {
            log.warn("Entry is directory in JAR. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resource);
            return Collections.emptyMap();
        }
        try (InputStream in = jarFile.getInputStream(entry);){
            Map map = this.reader.read(in);
            return map;
        }
    }
}

