/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.config.loaders;

import com.huawei.fit.plugin.gateway.config.LoadBalanceConfigLoader;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.core.common.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLoadBalanceConfigLoader
implements LoadBalanceConfigLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalLoadBalanceConfigLoader.class);
    private final File resource;
    private final ConfigurationReader reader;

    public LocalLoadBalanceConfigLoader(File resource, ConfigurationReader reader) {
        this.resource = resource;
        this.reader = reader;
    }

    @Override
    public Map<String, Object> read() {
        if (!this.resource.exists()) {
            log.debug("Load balance configuration file not found. [path={}]", (Object)FileUtils.path((File)this.resource));
            return Collections.emptyMap();
        }
        if (this.resource.isDirectory()) {
            log.warn("Load balance configuration file is directory. [path={}]", (Object)FileUtils.path((File)this.resource));
            return Collections.emptyMap();
        }
        try {
            return this.reader.read(this.resource);
        }
        catch (IOException e) {
            log.warn("Fail to read load balance config from file. [path={}]", (Object)FileUtils.path((File)this.resource));
            log.debug("Fail to read load balance config from file.", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

