/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.converter;

import com.huawei.fit.plugin.gateway.converter.Converter;
import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.enums.HttpParamType;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamMappingConverter
implements Converter<Map<String, Object>, ParamMapping> {
    private static final String PARAM = "param";
    private static final Pattern PATTERN = Pattern.compile("^\\$\\[(\\d+)]((\\.[^.]+)*)$");
    private static final String FROM = "from";
    private static final String KEY = "key";
    private static final String DEFAULT_VALUE = "default-value";
    private static final String DOT = ".";
    private static final String PARAM_TYPE = "param-type";
    private static final int MAX_PARAM_LENGTH = 1024;

    @Override
    public ParamMapping convert(Map<String, Object> paramConfig) {
        String param = (String)ObjectUtils.cast((Object)paramConfig.get(PARAM));
        Validation.isTrue((boolean)StringUtils.isNotBlank((String)param), () -> new IllegalArgumentException("Param is blank"));
        Validation.isTrue((param.length() <= 1024 ? 1 : 0) != 0, () -> new IllegalArgumentException(StringUtils.format((String)"Param length exceed 1024, param: {0}", (Object[])new Object[]{param})));
        Matcher matcher = PATTERN.matcher(param);
        Validation.isTrue((boolean)matcher.find(), () -> new IllegalArgumentException(StringUtils.format((String)"Invalid rest mapping: {0}", (Object[])new Object[]{param})));
        ParamMapping paramMapping = new ParamMapping();
        paramMapping.setFrom(HttpParamType.valueOf((String)ObjectUtils.cast((Object)paramConfig.get(FROM))));
        paramMapping.setFromKey((String)ObjectUtils.cast((Object)paramConfig.get(KEY)));
        paramMapping.setDefaultValue((String)ObjectUtils.cast((Object)paramConfig.get(DEFAULT_VALUE)));
        paramMapping.setIndex(Integer.valueOf(matcher.group(1)));
        paramMapping.setToKey(this.trimKey(matcher.group(2)));
        paramMapping.setTo(ParamTypeEnum.getOrDefault((String)ObjectUtils.cast((Object)paramConfig.get(PARAM_TYPE))));
        return paramMapping;
    }

    private String trimKey(String rawKey) {
        if (StringUtils.isBlank((String)rawKey)) {
            return "";
        }
        if (rawKey.startsWith(DOT)) {
            return rawKey.replaceFirst(DOT, "");
        }
        return rawKey;
    }
}

