/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.converter;

import com.huawei.fit.plugin.gateway.converter.Converter;
import com.huawei.fit.plugin.gateway.converter.ParamMappingConverter;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RestMappingConverter
implements Converter<Map<String, Object>, List<RestMapping>> {
    private static final String ID = "id";
    private static final String REST = "rest";
    private static final String TYPE = "type";
    private static final String MAPPINGS = "mappings";
    private final ParamMappingConverter converter = new ParamMappingConverter();

    @Override
    public List<RestMapping> convert(Map<String, Object> genericableConfig) {
        String genericableId = Validation.notBlank((String)((String)ObjectUtils.cast((Object)genericableConfig.get(ID))), (String)"No genericableId config.", (Object[])new Object[0]);
        Map restConfig = (Map)ObjectUtils.cast((Object)genericableConfig.get(REST));
        if (MapUtils.isEmpty((Map)restConfig)) {
            return Collections.emptyList();
        }
        String type = (String)ObjectUtils.cast(restConfig.get(TYPE));
        List mappings = (List)Validation.notNull((Object)ObjectUtils.cast(restConfig.get(MAPPINGS)), (String)"No mapping config. [genericableId={0}]", (Object[])new Object[]{genericableId});
        return mappings.stream().filter(Objects::nonNull).map(mappingConfig -> this.convert(genericableId, type, (Map<String, Object>)mappingConfig)).collect(Collectors.toList());
    }

    private RestMapping convert(String genericableId, String type, Map<String, Object> mappingConfig) {
        RestMapping restMapping = new RestMapping();
        restMapping.setUri((String)ObjectUtils.cast((Object)mappingConfig.get("uri")));
        restMapping.setGenericId(genericableId);
        restMapping.setMethod(HttpMethod.from((String)ObjectUtils.cast((Object)mappingConfig.get("method"))));
        restMapping.setHttpType(type);
        List params = (List)ObjectUtils.cast((Object)mappingConfig.get("params"));
        if (params != null) {
            restMapping.setParamMappings(params.stream().filter(Objects::nonNull).map(this.converter::convert).collect(Collectors.toList()));
        }
        return restMapping;
    }
}

