/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.filter;

import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.server.http.AbstractFilterSupplier;
import com.huawei.fitframework.broker.server.http.FilterOrder;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Fitable
@FilterOrder(value=-2000)
public class CorsFilterSupplier
extends AbstractFilterSupplier
implements Filter {
    private static final String ALLOW_ORIGIN_KEY = "Access-Control-Allow-Origin";
    private static final String ALLOW_METHODS_KEY = "Access-Control-Allow-Methods";
    private static final String ALLOW_HEADERS_KEY = "Access-Control-Allow-Headers";
    private static final String ALLOW_CREDENTIALS_KEY = "Access-Control-Allow-Credentials";
    private static final String ALLOW_METHODS_VALUE = "*";
    private static final String ALLOW_ORIGIN_VALUE = "*";
    private static final String ALLOW_HEADERS_VALUE = "*";
    private static final String ALLOW_CREDENTIALS_VALUE = "true";

    public Filter filter() {
        return this;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)ObjectUtils.cast((Object)response);
        HttpServletRequest req = (HttpServletRequest)ObjectUtils.cast((Object)request);
        resp.addHeader(ALLOW_HEADERS_KEY, "*");
        resp.setHeader(ALLOW_ORIGIN_KEY, "*");
        resp.setHeader(ALLOW_METHODS_KEY, "*");
        resp.setHeader(ALLOW_CREDENTIALS_KEY, ALLOW_CREDENTIALS_VALUE);
        if (StringUtils.equalsIgnoreCase((String)req.getMethod(), (String)HttpMethod.OPTIONS.name())) {
            resp.setStatus(200);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }
}

