/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.filter;

import com.huawei.fit.plugin.gateway.config.LoadBalanceConfigLoader;
import com.huawei.fit.plugin.gateway.config.LoadBalanceConfigurator;
import com.huawei.fit.plugin.gateway.config.entity.LoadBalanceConfig;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.sdk.context.PutLocalContext;
import com.huawei.fit.sdk.context.RemoveLocalContext;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.server.http.AbstractFilterSupplier;
import com.huawei.fitframework.broker.server.http.FilterOrder;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.plugin.PluginException;
import com.huawei.fitframework.runtime.SystemDirectories;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@FilterOrder(value=-3000)
public class LoadBalanceConfigFilterSupplier
extends AbstractFilterSupplier
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadBalanceConfigFilterSupplier.class);
    private static final String LOAD_BALANCE_KEY = "fit.loadBalance.{0}";
    private static final String PLUGIN_NAME = "fit-rest-gateway";
    private static final int DEFAULT_REFRESH_INTERVAL = 5;
    private final LoadBalanceConfig loadBalanceConfig;
    private final PutLocalContext putLocalContext;
    private final RemoveLocalContext removeLocalContext;
    private final MappingRepository mappingRepository;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final int refreshInterval;
    private final File loadBalanceDirectory;

    public LoadBalanceConfigFilterSupplier(PutLocalContext putLocalContext, RemoveLocalContext removeLocalContext, MappingRepository.Factory mappingRepositoryFactory, @Value(value="${repo.load-balance.refresh.interval}") Integer refreshInterval, @Value(value="${plugin.directory}") String pluginDirectory, @Value(value="${repo.load-balance.directory}") String loadBalanceDirectory) {
        this.putLocalContext = putLocalContext;
        this.removeLocalContext = removeLocalContext;
        this.mappingRepository = MappingRepository.get(mappingRepositoryFactory);
        this.loadBalanceConfig = new LoadBalanceConfig();
        this.refreshInterval = (Integer)ObjectUtils.nullIf((Object)refreshInterval, (Object)5);
        File plugin = FileUtils.canonicalize((File)new File(pluginDirectory));
        this.loadBalanceDirectory = new File(plugin, loadBalanceDirectory);
    }

    @PostConstruct
    public void initialize() {
        this.loadConfig();
        this.executor.scheduleAtFixedRate(this::refresh, this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
    }

    private void refresh() {
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            log.error("Fail to refresh load balance config. [error={}]", (Object)e.getMessage());
            log.debug(ExceptionUtils.getReason((Throwable)e), (Throwable)e);
        }
    }

    public void loadConfig() {
        SystemDirectories.Plugin gatewayPlugin = SystemDirectories.allPlugins().stream().filter(plugin -> Objects.equals(plugin.name(), PLUGIN_NAME)).findFirst().orElseThrow(() -> new PluginException(StringUtils.format((String)"Plugin is not found. [plugin={0}]", (Object[])new Object[]{PLUGIN_NAME})));
        File[] files = gatewayPlugin.lib().listFiles();
        Validation.notNull((Object)files, () -> new IllegalStateException(StringUtils.format((String)"Plugin's lib file is not found. [plugin={0}]", (Object[])new Object[]{PLUGIN_NAME})));
        Set configGenericableIds = Arrays.stream(files).filter(File::isFile).filter(FileUtils::isJar).map(this::readAndConfigure).reduce(new HashSet(), CollectionUtils::union);
        Set genericableIdsFromLocal = Optional.of(this.loadBalanceDirectory).filter(File::exists).filter(File::isDirectory).map(File::listFiles).map(this::readFiles).orElseGet(HashSet::new);
        configGenericableIds.addAll(genericableIdsFromLocal);
        this.clearDeprecatedConf(configGenericableIds);
    }

    private void clearDeprecatedConf(Set<String> configGenericableIds) {
        this.loadBalanceConfig.getGenericables().keySet().retainAll(configGenericableIds);
    }

    private Set<String> readFiles(File[] files) {
        return Stream.of(files).filter(LoadBalanceConfigFilterSupplier::isResourceFile).map(this::readAndConfigure).reduce(new HashSet(), CollectionUtils::union);
    }

    private Set<String> readAndConfigure(File file) {
        LoadBalanceConfigLoader loader = LoadBalanceConfigLoader.loader(file);
        LoadBalanceConfigurator configurator = new LoadBalanceConfigurator(loader.read(), file);
        return configurator.configure(this.loadBalanceConfig);
    }

    private static boolean isResourceFile(File file) {
        return file.getName().endsWith("load-balance.properties");
    }

    public Filter filter() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        String uri = request.getRequestURI();
        String httpMethod = request.getMethod();
        Optional<RestMapping> restMappingOptional = this.mappingRepository.get(uri, HttpMethod.from(httpMethod));
        try {
            restMappingOptional.ifPresent(mapping -> this.handleRestMapping((RestMapping)mapping, (arg_0, arg_1) -> ((PutLocalContext)this.putLocalContext).process(arg_0, arg_1)));
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            restMappingOptional.ifPresent(mapping -> this.handleRestMapping((RestMapping)mapping, (key, value) -> this.removeLocalContext.process(key)));
        }
    }

    private void handleRestMapping(RestMapping restMapping, BiConsumer<String, String> action) {
        String genericableId = restMapping.getGenericId();
        this.loadBalanceConfig.getLoadBalance(genericableId).ifPresent(loadBalance -> action.accept(this.assembleKey(genericableId), (String)loadBalance));
    }

    private String assembleKey(String genericableId) {
        return StringUtils.format((String)LOAD_BALANCE_KEY, (Object[])new Object[]{genericableId});
    }
}

