/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.filter;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.sdk.context.PutLocalContext;
import com.huawei.fit.sdk.context.RemoveLocalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.server.http.AbstractFilterSupplier;
import com.huawei.fitframework.broker.server.http.FilterOrder;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@FilterOrder(value=-1000)
public class RestMappingFilterSupplier
extends AbstractFilterSupplier
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestMappingFilterSupplier.class);
    private static final String INTERNAL_REQUEST_URI = "/fit";
    private static final String IS_LOGOUT = "isLogout";
    private static final String LOGOUT_VALUE = "logout";
    private static final String LOGOUT_RESULT = "true";
    private final PutLocalContext putLocalContext;
    private final RemoveLocalContext removeLocalContext;
    private final MappingRepository mappingRepository;

    public RestMappingFilterSupplier(@Fit PutLocalContext putLocalContext, @Fit RemoveLocalContext removeLocalContext, @Fit MappingRepository.Factory repoFactory) {
        this.putLocalContext = putLocalContext;
        this.removeLocalContext = removeLocalContext;
        this.mappingRepository = MappingRepository.get(repoFactory);
    }

    public Filter filter() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)ObjectUtils.cast((Object)request);
        if (this.isFitInternalRequest(req)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse resp = (HttpServletResponse)ObjectUtils.cast((Object)response);
        String uri = req.getRequestURI();
        String httpMethod = req.getMethod();
        log.debug("Request: {} {}", (Object)httpMethod, (Object)uri);
        Optional<RestMapping> opRestMapping = this.mappingRepository.get(uri, HttpMethod.from(httpMethod));
        if (!opRestMapping.isPresent()) {
            resp.sendError(404);
            return;
        }
        RestMapping restMapping = opRestMapping.get();
        log.debug("Request: {} {} to genericable {}.", new Object[]{httpMethod, uri, restMapping.getGenericId()});
        try {
            if (Objects.equals(restMapping.getHttpType(), LOGOUT_VALUE)) {
                this.putLocalContext.process(IS_LOGOUT, LOGOUT_RESULT);
            }
            chain.doFilter(request, response);
        }
        finally {
            this.removeLocalContext.process(IS_LOGOUT);
        }
    }

    private boolean isFitInternalRequest(HttpServletRequest request) {
        return INTERNAL_REQUEST_URI.equals(request.getRequestURI());
    }
}

