/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.param;

import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.entity.PartParamInfo;
import com.huawei.fit.plugin.gateway.enums.HttpParamType;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;

public class ClassifiedParam {
    private static final int DEFAULT_INDEX = -1;
    private final int index;
    private final List<ParamMapping> params = new ArrayList<ParamMapping>();

    private ClassifiedParam(int index, ParamMapping paramMapping) {
        this.index = index;
        this.params.add(paramMapping);
    }

    public String getFirstKey() {
        return this.params.get(0).getToKey();
    }

    public boolean isJsonComplicatedParam() {
        return this.getDefault().getTo() == ParamTypeEnum.PARAM && this.getDefault().getFrom() == HttpParamType.JSON_BODY;
    }

    public ParamTypeEnum getParamType() {
        return this.params.get(0).getTo();
    }

    public ParamMapping getDefault() {
        return this.params.get(0);
    }

    public String getRootKey() {
        return this.params.get(0).getToKey();
    }

    public List<ParamMapping> getChildren() {
        return this.params.size() <= 1 ? new ArrayList<ParamMapping>() : this.params.subList(1, this.params.size());
    }

    public boolean isSimpleType() {
        if (this.params.size() > 1) {
            return false;
        }
        PartParamInfo partParamInfo = new PartParamInfo(this.getDefault().getToKey());
        return partParamInfo.getAttributeNames().size() <= 1;
    }

    public static List<ClassifiedParam> classifyParams(List<ParamMapping> paramMappings) {
        if (paramMappings.stream().anyMatch(param -> param.getIndex() == null)) {
            return ClassifiedParam.getSimpleTypeParams(paramMappings);
        }
        ArrayList contexts = new ArrayList();
        TreeMap paramMap = new TreeMap();
        paramMappings.forEach(param -> {
            if (param.getTo() == ParamTypeEnum.CONTEXT) {
                contexts.add(new ClassifiedParam(-1, (ParamMapping)param));
            } else {
                ClassifiedParam.getNonContextParams(paramMap, param);
            }
        });
        paramMap.values().forEach(sorted -> sorted.getParams().sort(Comparator.comparing(ParamMapping::getToKey)));
        return CollectionUtils.connect((List[])new List[]{new ArrayList(paramMap.values()), contexts});
    }

    private static List<ClassifiedParam> getSimpleTypeParams(List<ParamMapping> paramMappings) {
        ArrayList<ClassifiedParam> simpleParamList = new ArrayList<ClassifiedParam>();
        int paramIndex = 0;
        for (ParamMapping param : paramMappings) {
            simpleParamList.add(new ClassifiedParam(paramIndex++, param));
        }
        return simpleParamList;
    }

    private static void getNonContextParams(Map<Integer, ClassifiedParam> paramMap, ParamMapping param) {
        Integer paramIndex = param.getIndex();
        if (paramIndex < 0) {
            throw new IllegalArgumentException(StringUtils.format((String)"Invalid index: {0}, paramMapping: {1}", (Object[])new Object[]{paramIndex, param}));
        }
        ClassifiedParam classified = paramMap.get(paramIndex);
        if (classified == null) {
            classified = new ClassifiedParam(paramIndex, param);
        } else {
            classified.params.add(param);
        }
        paramMap.put(paramIndex, classified);
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public List<ParamMapping> getParams() {
        return this.params;
    }
}

