/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.param.chain;

import com.huawei.fit.plugin.gateway.entity.HttpContext;
import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.PartParamInfo;
import com.huawei.fit.plugin.gateway.param.ClassifiedParam;
import com.huawei.fit.plugin.gateway.param.chain.ParserChain;
import com.huawei.fit.plugin.gateway.utils.JsonParamUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBodyParamParser
implements ParserChain {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonBodyParamParser.class);
    private static final String DOT = ".";
    private static final String BRACKET_STAR = "[*]";

    @Override
    public Object parse(ClassifiedParam classified, HttpContext context, BiFunction<ParamMapping, HttpContext, Object> valueGetter) {
        Object paramObject = this.tryGetJsonObject(classified, context, valueGetter);
        if (paramObject == null) {
            return null;
        }
        classified.getChildren().forEach(param -> {
            String targetKey;
            DocumentContext documentContext = JsonPath.parse((Object)paramObject);
            String sourceKey = this.getSourceKey((ParamMapping)param);
            if (!StringUtils.equals((String)sourceKey, (String)(targetKey = this.getTargetKey((ParamMapping)param)))) {
                String keyParentPath = this.getKeyParentPath(classified, (ParamMapping)param);
                try {
                    documentContext.renameKey(keyParentPath, sourceKey, targetKey, new Predicate[0]).json();
                }
                catch (PathNotFoundException exception) {
                    this.setDefaultValueToTargetKay(documentContext, sourceKey, targetKey, keyParentPath, param.getDefaultValue());
                }
            } else {
                log.info("Do not rename with jarway: source key equals to target key. [sourceKey={}]", (Object)sourceKey);
            }
        });
        return paramObject;
    }

    private void setDefaultValueToTargetKay(DocumentContext documentContext, String sourceKey, String targetKey, String keyParentPath, String defaultValue) {
        List paths = (List)documentContext.read(keyParentPath, List.class, new Predicate[0]);
        if (paths == null) {
            documentContext.put(keyParentPath, targetKey, (Object)defaultValue, new Predicate[0]).json();
            return;
        }
        paths.forEach(path -> {
            if (path.get(targetKey) == null && path.get(sourceKey) == null) {
                path.put(targetKey, defaultValue);
            } else if (path.get(targetKey) == null && path.get(sourceKey) != null) {
                path.put(targetKey, path.get(sourceKey));
                path.remove(sourceKey);
            } else {
                log.info("target key is already existed. [targetKey={}]", (Object)targetKey);
            }
        });
    }

    @Override
    public boolean match(ClassifiedParam classifiedParam) {
        return classifiedParam.isJsonComplicatedParam();
    }

    private Object tryGetJsonObject(ClassifiedParam classified, HttpContext context, BiFunction<ParamMapping, HttpContext, Object> valueGetter) {
        Object paramObject = null;
        try {
            paramObject = valueGetter.apply(classified.getDefault(), context);
        }
        catch (PathNotFoundException e) {
            log.error("Path not found, param: {}", (Object)classified.getDefault());
        }
        return paramObject;
    }

    private String getKeyParentPath(ClassifiedParam classified, ParamMapping param) {
        String toCutTail = this.cutHead(classified, param);
        String rawPath = this.cutTail(toCutTail, this.getTargetKey(param));
        return JsonParamUtils.decorateJsonKey(rawPath);
    }

    private String cutHead(ClassifiedParam classified, ParamMapping param) {
        if (param.getToKey().startsWith(classified.getRootKey() + DOT)) {
            return param.getToKey().replaceFirst(classified.getRootKey() + DOT, "");
        }
        if (param.getToKey().startsWith(classified.getRootKey() + BRACKET_STAR)) {
            return param.getToKey().replaceFirst(classified.getRootKey(), "");
        }
        log.error("Cannot analyze classifiedParam: {}, current param: {}", (Object)classified, (Object)param);
        throw new IllegalArgumentException(StringUtils.format((String)"Cannot analyze classifiedParam: {0}, current param: {1}", (Object[])new Object[]{classified, param}));
    }

    private String cutTail(String source, String tail) {
        int dotTailIndex = source.lastIndexOf(DOT + tail);
        if (dotTailIndex >= 0) {
            return source.substring(0, dotTailIndex);
        }
        int tailIndex = source.lastIndexOf(tail);
        if (tailIndex >= 0) {
            return source.substring(0, tailIndex);
        }
        log.error("Cannot cut tail for param, source: {}, tail: {}", (Object)source, (Object)tail);
        throw new IllegalArgumentException(StringUtils.format((String)"Cannot cut tail for param, source: {0}, tail: {1}", (Object[])new Object[]{source, tail}));
    }

    private String getTargetKey(ParamMapping param) {
        return new PartParamInfo(param.getToKey()).getLastAttribute();
    }

    private String getSourceKey(ParamMapping param) {
        return new PartParamInfo(param.getFromKey()).getLastAttribute();
    }
}

