/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.parser;

import com.huawei.fit.plugin.gateway.converter.RestMappingConverter;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.parser.Parser;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.serialization.YamlSerializer;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Fitable
public class DefaultParser
implements Parser {
    private static final String GENERICABLES = "genericables";
    private final RestMappingConverter converter = new RestMappingConverter();
    private final YamlSerializer yamlSerializer;

    public DefaultParser(@Fit YamlSerializer yamlSerializer) {
        this.yamlSerializer = yamlSerializer;
    }

    @Override
    public List<RestMapping> parse(InputStream in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return this.getGenericableConfigs(this.yamlSerializer.deserialize(in)).stream().map(this.converter::convert).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getGenericableConfigs(Map<String, Object> genericablesConfig) {
        List genericableConfigs = (List)genericablesConfig.get(GENERICABLES);
        if (genericableConfigs == null) {
            return Collections.emptyList();
        }
        return genericableConfigs;
    }
}

