/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.parser;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

@Genericable
public interface Parser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public List<RestMapping> parse(JarFile jarFile, String entryName) {
        ZipEntry entry = jarFile.getEntry(entryName);
        if (entry == null) {
            return Collections.emptyList();
        }
        try (InputStream in = jarFile.getInputStream(entry);){
            List<RestMapping> list = this.parse(in);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format((String)"Parse file error. [file={0}]", (Object[])new Object[]{jarFile.getName()}), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public List<RestMapping> parse(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            List<RestMapping> list = this.parse(in);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format((String)"Parse file error. [file={0}]", (Object[])new Object[]{file.getName()}), e);
        }
    }

    public List<RestMapping> parse(InputStream var1);
}

