/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository;

import com.huawei.fit.plugin.gateway.repository.RepoConfig;
import com.huawei.fit.plugin.gateway.utils.ValueUtils;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class GenericableRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericableRegistry.class);
    private final RepoConfig conf;
    private final ConfigurationLoader loader;
    private final ScheduledExecutorService executor;
    private final Map<File, String> signatures;

    public GenericableRegistry(@Fit RepoConfig conf, @Fit ConfigurationLoader loader) {
        this.conf = (RepoConfig)Validation.notNull((Object)conf, (String)"The configuration for repo cannot be null.", (Object[])new Object[0]);
        this.loader = (ConfigurationLoader)Validation.notNull((Object)loader, (String)"The loader for broker configuration cannot be null.", (Object[])new Object[0]);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.signatures = new HashMap<File, String>();
    }

    @PostConstruct
    public void initialize() {
        this.loadGenericables();
        this.executor.scheduleAtFixedRate(this::refresh, this.conf.refresh().interval(), this.conf.refresh().interval(), TimeUnit.SECONDS);
    }

    private void refresh() {
        try {
            this.loadGenericables();
        }
        catch (Exception e) {
            log.warn("Fail to refresh genericable configs. [error={}]", (Object)e.getMessage());
            log.debug("Fail to refresh genericable configs.", (Throwable)e);
        }
    }

    private void loadGenericables() {
        log.info("Start to load genericable configs.");
        File[] files = this.conf.genericables().directory().listFiles();
        Arrays.stream((Object[])ObjectUtils.nullIf((Object)files, (Object)new File[0])).filter(this::isRepoFile).forEach(this::loadGenericables);
        log.info("Finish to load genericable configs.");
    }

    private boolean isRepoFile(File file) {
        return StringUtils.endsWithIgnoreCase((String)file.getName(), (String)this.conf.genericables().extension());
    }

    private void loadGenericables(File file) {
        String signature = ValueUtils.digest(file, this.conf.digest().algorithm(), this.conf.digest().bufferSize());
        if (StringUtils.equals((String)this.signatures.get(file), (String)signature)) {
            log.info("The genericable config file is not changed. Skip. [file={}]", (Object)FileUtils.path((File)file));
        } else {
            log.info("The genericable config file is changed. Reload. [file={}]", (Object)FileUtils.path((File)file));
            this.configure(file);
            this.signatures.put(file, signature);
        }
    }

    private void configure(File file) {
        ConfigurableBrokerConfiguration broker = (ConfigurableBrokerConfiguration)ObjectUtils.cast((Object)this.loader.load());
        BrokerConfigurationConfigurator.file((File)file, (ConfigurationReader)ConfigurationReader.properties()).configure(broker, ConfigureMode.APPEND);
    }
}

