/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.TreeNode;
import com.huawei.fit.plugin.gateway.repository.TreeNodeImpl;
import com.huawei.fit.plugin.gateway.utils.UriUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingTree {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MappingTree.class);
    private final Map<HttpMethod, TreeNode> roots = new ConcurrentHashMap<HttpMethod, TreeNode>();

    public MappingTree() {
        Stream.of(HttpMethod.values()).forEach(httpMethod -> this.roots.put((HttpMethod)((Object)httpMethod), new TreeNodeImpl("")));
    }

    public final void insert(RestMapping restMapping) {
        HttpMethod httpMethod;
        String patternUri;
        if (restMapping == null) {
            return;
        }
        try {
            patternUri = Validation.notBlank((String)restMapping.getUri(), (String)"uri of RestMapping is empty.", (Object[])new Object[0]);
            httpMethod = (HttpMethod)((Object)Validation.notNull((Object)((Object)restMapping.getMethod()), (String)"Http method is null.", (Object[])new Object[0]));
            Validation.isTrue((boolean)patternUri.startsWith("/"), (String)"pattern uri is invalid.", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.warn("Fail to insert rest mapping: {}.", (Object)e.getMessage());
            return;
        }
        TreeNode current = this.roots.get((Object)httpMethod);
        UriIterator iterator = new UriIterator(patternUri.substring(1));
        while (iterator.hasNext()) {
            String identifier = iterator.next();
            UriType uriType = UriType.toEnum(identifier);
            Optional<TreeNode> nodeOp = uriType.getChild(identifier, current);
            if (nodeOp.isPresent()) {
                current = nodeOp.get();
                continue;
            }
            TreeNodeImpl newNode = new TreeNodeImpl(identifier);
            uriType.insert(current, newNode);
            current = newNode;
        }
        current.getValue().ifPresent(originalMapping -> {
            if (!Objects.equals(originalMapping.getGenericId(), restMapping.getGenericId())) {
                log.warn("rest mapping config changed,uri={},method={},original genericId={},present genericId={}", new Object[]{restMapping.getUri(), restMapping.getMethod(), originalMapping.getGenericId(), restMapping.getGenericId()});
            }
        });
        current.setValue(restMapping);
    }

    public final Optional<RestMapping> query(String requestUri, HttpMethod httpMethod) {
        if (StringUtils.isBlank((String)requestUri)) {
            return Optional.empty();
        }
        if (!requestUri.startsWith("/")) {
            throw new IllegalArgumentException("pattern uri is invalid.");
        }
        UriIterator iterator = new UriIterator(requestUri.substring(1));
        TreeNode current = this.roots.get((Object)httpMethod);
        while (iterator.hasNext() && current != null) {
            String identifier = iterator.next();
            Optional<TreeNode> nodeOptional = current.getChild(identifier);
            current = nodeOptional.isPresent() ? nodeOptional.get() : (TreeNode)current.getPathVariableNode().orElse(null);
        }
        return current == null ? Optional.empty() : current.getValue();
    }

    private static class UriIterator
    implements Iterator<String> {
        private int index = 0;
        private final String[] identifiers;

        UriIterator(String patternUri) {
            this.identifiers = StringUtils.split((String)patternUri, (char)'/');
        }

        @Override
        public boolean hasNext() {
            return this.index != this.identifiers.length;
        }

        @Override
        public String next() {
            return this.identifiers[this.index++];
        }
    }

    private static enum UriType {
        PATH_VARIABLE{

            @Override
            public Optional<TreeNode> getChild(String identifier, TreeNode current) {
                return current.getPathVariableNode();
            }

            @Override
            public void insert(TreeNode current, TreeNode newNode) {
                current.setPathVariableNode(newNode);
            }
        }
        ,
        NORMAL{

            @Override
            public Optional<TreeNode> getChild(String identifier, TreeNode current) {
                return current.getChild(identifier);
            }

            @Override
            public void insert(TreeNode current, TreeNode newNode) {
                current.insert(newNode);
            }
        };


        protected abstract Optional<TreeNode> getChild(String var1, TreeNode var2);

        protected abstract void insert(TreeNode var1, TreeNode var2);

        public static UriType toEnum(String identifier) {
            if (UriUtils.isPathVariable(identifier)) {
                return PATH_VARIABLE;
            }
            return NORMAL;
        }
    }
}

