/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Genericable
public interface RestMappingLoader {
    public List<RestMapping> load(InputStream var1) throws IOException;

    default public List<RestMapping> load(File file) throws IOException {
        Validation.notNull((Object)file, (String)"The file to load REST mappings cannot be null.", (Object[])new Object[0]);
        try (FileInputStream in = new FileInputStream(file);){
            List<RestMapping> list = this.load(in);
            return list;
        }
    }

    default public List<RestMapping> load(String content) throws IOException {
        Validation.notNull((Object)content, (String)"The content to load REST mappings cannot be null.", (Object[])new Object[0]);
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            List<RestMapping> list = this.load(in);
            return list;
        }
    }
}

