/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.repository.TreeNode;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class TreeNodeImpl
implements TreeNode {
    private final String identifier;
    private final Map<String, TreeNode> children;
    private volatile TreeNode pathVariableNode;
    private volatile RestMapping restMapping;

    public TreeNodeImpl(String identifier) {
        this(identifier, null);
    }

    public TreeNodeImpl(String identifier, RestMapping restMapping) {
        this.identifier = identifier;
        this.restMapping = restMapping;
        this.children = new ConcurrentHashMap<String, TreeNode>();
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Optional<TreeNode> getChild(String identifier) {
        return Optional.ofNullable(this.children.get(identifier));
    }

    @Override
    public void insert(TreeNode node) {
        this.children.put(node.identifier(), node);
    }

    @Override
    public void setPathVariableNode(TreeNode node) {
        this.pathVariableNode = node;
    }

    @Override
    public Optional<TreeNode> getPathVariableNode() {
        return Optional.ofNullable(this.pathVariableNode);
    }

    @Override
    public void setValue(RestMapping restMapping) {
        this.restMapping = restMapping;
    }

    @Override
    public Optional<RestMapping> getValue() {
        return Optional.ofNullable(this.restMapping);
    }
}

