/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.plugin.gateway.repository.MappingTree;
import com.huawei.fit.plugin.gateway.repository.RestMappingLoader;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.PluginBrief;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Alias(value="mapping-repository.config-center")
public class ConfigCenterMappingRepository
implements MappingRepository,
ApplicationStartedObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigCenterMappingRepository.class);
    private static final Pattern PATTERN = Pattern.compile("^([A-Za-z0-9]{32})\\.rest-configs$");
    private static final String REST_CONFIG_GROUP = "gateway:rest-config";
    private static final String CONFIG_PATH = "fit.public.rest-configs";
    private final RestMappingLoader loader;
    private final ConfigCenterClient client;
    private Map<String, MappingTree> genericableIdMappingTreeMappings;

    public ConfigCenterMappingRepository(@Fit(alias="rest-config.loader.json") RestMappingLoader loader, @Fit ConfigCenterClient client, @Fit ConfigCenterListener listener) {
        this.loader = loader;
        this.client = client;
        listener.addSubscriptionGroupConsumer(REST_CONFIG_GROUP, this::notify);
        this.genericableIdMappingTreeMappings = new ConcurrentHashMap<String, MappingTree>();
    }

    public void onApplicationStarted(List<PluginBrief> plugins) {
        this.client.subscribe(REST_CONFIG_GROUP, CONFIG_PATH);
        this.client.download(CONFIG_PATH, this::notify);
    }

    private void notify(String configPath, Map<String, String> configsMap) {
        HashMap<String, MappingTree> map = new HashMap<String, MappingTree>();
        configsMap.forEach((key, value) -> {
            String genericableId = this.getGenericableId((String)key);
            if (genericableId == null) {
                return;
            }
            map.put(genericableId, this.toMappingTree((String)value));
        });
        this.genericableIdMappingTreeMappings = map;
    }

    private String getGenericableId(String configKey) {
        Matcher matcher = PATTERN.matcher(configKey);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public Optional<RestMapping> get(String requestUri, HttpMethod httpMethod) {
        for (MappingTree mappingTree : this.genericableIdMappingTreeMappings.values()) {
            Optional<RestMapping> restMapping = mappingTree.query(requestUri, httpMethod);
            if (!restMapping.isPresent()) continue;
            return restMapping;
        }
        return Optional.empty();
    }

    private MappingTree toMappingTree(String restMappingConfig) {
        MappingTree mappingTree = new MappingTree();
        Optional.ofNullable(restMappingConfig).filter(StringUtils::isNotBlank).map(this::deserialize).ifPresent(restConfigs -> restConfigs.forEach(mappingTree::insert));
        return mappingTree;
    }

    private List<RestMapping> deserialize(String json) {
        try {
            return this.loader.load(json);
        }
        catch (IOException e) {
            log.warn("Fail to deserialize rest configs, skip. [reason={}]", (Object)e.getMessage());
            log.debug("Fail to deserialize rest configs, skip.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

