/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.repository.RepoConfig;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Fitable
public class DefaultRepoConfig
implements RepoConfig {
    private static final int DEFAULT_REFRESH_INTERVAL = 5;
    private static final String DEFAULT_REST_MAPPINGS_DIRECTORY = "repo/rests";
    private static final String DEFAULT_REST_MAPPINGS_EXTENSION = ".rests.json";
    private static final List<String> DEFAULT_REST_MAPPINGS_ACTIVE = Arrays.asList("mapping-repository.embedded", "mapping-repository.local-file", "mapping-repository.config-center");
    private static final String DEFAULT_GENERICABLES_DIRECTORY = "repo/genericables";
    private static final String DEFAULT_GENERICABLES_EXTENSION = ".genericables.properties";
    private static final String DEFAULT_DIGEST_ALGORITHM = "MD5";
    private static final int DEFAULT_DIGEST_BUFFER_SIZE = 512;
    private final int refreshInterval;
    private final File restMappingsDirectory;
    private final String restMappingsExtension;
    private final List<String> restMappingsActive;
    private final File genericablesDirectory;
    private final String genericablesExtension;
    private final String digestAlgorithm;
    private final int digestBufferSize;
    private final RefreshConfig refresh;
    private final RepoConfig.RestMappingsConfig restMappings;
    private final GenericablesConfig genericables;
    private final DigestConfig digest;

    public DefaultRepoConfig(@Value(value="${plugin.directory}") String pluginDirectory, @Value(value="${repo.refresh.interval}") Integer refreshInterval, @Value(value="${repo.rest-mappings.directory}") String restMappingsDirectory, @Value(value="${repo.rest-mappings.extension}") String restMappingsExtension, @Value(value="${repo.rest-mappings.active}") List<String> restMappingsActive, @Value(value="${repo.genericables.directory}") String genericablesDirectory, @Value(value="${repo.genericables.extension}") String genericablesExtension, @Value(value="${repo.digest.algorithm}") String digestAlgorithm, @Value(value="${repo.digest.buffer-size}") Integer digestBufferSize) {
        Validation.notBlank((String)pluginDirectory, (String)"The base directory of current plugin cannot be blank.", (Object[])new Object[0]);
        File plugin = FileUtils.canonicalize((File)new File(pluginDirectory));
        this.refreshInterval = (Integer)ObjectUtils.nullIf((Object)refreshInterval, (Object)5);
        this.restMappingsDirectory = new File(plugin, DefaultRepoConfig.blankIf(restMappingsDirectory, DEFAULT_REST_MAPPINGS_DIRECTORY));
        this.restMappingsExtension = DefaultRepoConfig.blankIf(restMappingsExtension, DEFAULT_REST_MAPPINGS_EXTENSION);
        this.restMappingsActive = DefaultRepoConfig.actualRestMappingsActive(restMappingsActive);
        this.genericablesDirectory = new File(plugin, DefaultRepoConfig.blankIf(genericablesDirectory, DEFAULT_GENERICABLES_DIRECTORY));
        this.genericablesExtension = DefaultRepoConfig.blankIf(genericablesExtension, DEFAULT_GENERICABLES_EXTENSION);
        this.digestAlgorithm = DefaultRepoConfig.blankIf(digestAlgorithm, DEFAULT_DIGEST_ALGORITHM);
        this.digestBufferSize = (Integer)ObjectUtils.nullIf((Object)digestBufferSize, (Object)512);
        this.refresh = new RefreshConfig();
        this.restMappings = new RestMappings();
        this.genericables = new GenericablesConfig();
        this.digest = new DigestConfig();
    }

    private static String blankIf(String value, String defaultValue) {
        String actual = StringUtils.trim((String)value);
        if (StringUtils.isBlank((String)actual)) {
            actual = defaultValue;
        }
        return actual;
    }

    private static List<String> actualRestMappingsActive(List<String> value) {
        List<String> actual = value;
        if (CollectionUtils.isEmpty(actual) || (actual = actual.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            actual = DEFAULT_REST_MAPPINGS_ACTIVE;
        }
        return actual;
    }

    @Override
    public RepoConfig.RefreshConfig refresh() {
        return this.refresh;
    }

    @Override
    public RepoConfig.RestMappingsConfig restMappings() {
        return this.restMappings;
    }

    @Override
    public RepoConfig.GenericablesConfig genericables() {
        return this.genericables;
    }

    @Override
    public RepoConfig.DigestConfig digest() {
        return this.digest;
    }

    private class DigestConfig
    implements RepoConfig.DigestConfig {
        private DigestConfig() {
        }

        @Override
        public String algorithm() {
            return DefaultRepoConfig.this.digestAlgorithm;
        }

        @Override
        public int bufferSize() {
            return DefaultRepoConfig.this.digestBufferSize;
        }
    }

    private class GenericablesConfig
    implements RepoConfig.GenericablesConfig {
        private GenericablesConfig() {
        }

        @Override
        public File directory() {
            return DefaultRepoConfig.this.genericablesDirectory;
        }

        @Override
        public String extension() {
            return DefaultRepoConfig.this.genericablesExtension;
        }
    }

    private class RestMappings
    implements RepoConfig.RestMappingsConfig {
        private RestMappings() {
        }

        @Override
        public File directory() {
            return DefaultRepoConfig.this.restMappingsDirectory;
        }

        @Override
        public String extension() {
            return DefaultRepoConfig.this.restMappingsExtension;
        }

        @Override
        public List<String> active() {
            return DefaultRepoConfig.this.restMappingsActive;
        }
    }

    private class RefreshConfig
    implements RepoConfig.RefreshConfig {
        private RefreshConfig() {
        }

        @Override
        public int interval() {
            return DefaultRepoConfig.this.refreshInterval;
        }
    }
}

