/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.enums.HttpParamType;
import com.huawei.fit.plugin.gateway.repository.RestMappingLoader;
import com.huawei.fit.plugin.gateway.utils.ValueUtils;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.CodeableEnum;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.serialization.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Alias(value="rest-config.loader.json")
public class JsonRestMappingLoader
implements RestMappingLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonRestMappingLoader.class);
    private final JsonSerializer serializer;

    public JsonRestMappingLoader(@Fit JsonSerializer serializer) {
        this.serializer = (JsonSerializer)Validation.notNull((Object)serializer, (String)"The serializer for JSON cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public List<RestMapping> load(InputStream in) throws IOException {
        String content = IoUtils.read((InputStream)in, (Charset)StandardCharsets.UTF_8);
        return this.load(content);
    }

    @Override
    public List<RestMapping> load(String json) {
        List configs;
        try {
            configs = this.serializer.deserialize2List(json);
        }
        catch (SerializationException e) {
            log.warn("Fail to deserialize json when load mapping. [json={}]", (Object)json);
            log.debug("Fail to deserialize json when load mapping.", (Throwable)e);
            return Collections.emptyList();
        }
        return configs.stream().map(ValueUtils::cast).map(JsonRestMappingLoader::loadMapping).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static RestMapping loadMapping(Map<String, Object> values) {
        if (Boolean.FALSE.equals(values.get("restSwitch"))) {
            return null;
        }
        RestMapping mapping = RestMapping.builder().uri((String)ValueUtils.get(values, "uri")).genericId((String)ValueUtils.get(values, "genericId")).method(HttpMethod.from((String)ValueUtils.get(values, "method"))).ruleId((String)ValueUtils.get(values, "ruleId")).paramMappings(JsonRestMappingLoader.params((List)ValueUtils.get(values, "paramMappings"))).responseTemplate((String)ValueUtils.get(values, "responseTemplate")).build();
        try {
            Validation.notBlank((String)mapping.getUri(), (String)"Uri of mapping is empty.", (Object[])new Object[0]);
            Validation.notNull((Object)((Object)mapping.getMethod()), (String)"Method of mapping is null.", (Object[])new Object[0]);
            Validation.notBlank((String)mapping.getMethod().name(), (String)"Method of mapping is empty.", (Object[])new Object[0]);
            Validation.notBlank((String)mapping.getGenericId(), (String)"Genericable id of mapping is empty.", (Object[])new Object[0]);
            Validation.notNull((Object)mapping.getResponseTemplate(), (String)"Response template of mapping is null.", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.warn("Fail to load mapping: {}.", (Object)e.getMessage());
            return null;
        }
        log.debug("REST mapping loaded. [uri={}, method={}, genericable={}]", new Object[]{mapping.getUri(), mapping.getMethod().name(), mapping.getGenericId()});
        return mapping;
    }

    private static List<ParamMapping> params(List<Object> values) {
        return IntStream.range(0, ((List)ObjectUtils.nullIf(values, Collections.emptyList())).size()).mapToObj(index -> JsonRestMappingLoader.param(index, (Map)ValueUtils.cast(values.get(index)))).collect(Collectors.toList());
    }

    private static ParamMapping param(int index, Map<String, Object> values) {
        return ParamMapping.builder().from((HttpParamType)CodeableEnum.fromCode(HttpParamType.class, (String)((String)ValueUtils.get(values, "httpParamType")))).fromKey((String)ValueUtils.get(values, "configKey")).to(ParamTypeEnum.getOrDefault((String)ValueUtils.get(values, "paramType"))).toKey((String)ValueUtils.get(values, "key")).index((Integer)ObjectUtils.nullIf(ValueUtils.get(values, "index"), (Object)index)).defaultValue((String)ValueUtils.get(values, "defaultValue")).build();
    }
}

