/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.plugin.gateway.repository.MappingTree;
import com.huawei.fit.plugin.gateway.repository.RepoConfig;
import com.huawei.fit.plugin.gateway.repository.RestMappingLoader;
import com.huawei.fit.plugin.gateway.utils.ValueUtils;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.serialization.SerializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Alias(value="mapping-repository.local-file")
public class LocalMappingRepository
implements MappingRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalMappingRepository.class);
    private static final ParameterizedType VALUES_TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, Object.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final JsonSerializer serializer;
    private final RestMappingLoader loader;
    private final RepoConfig conf;
    private final Map<File, String> signatures;
    private final MappingTree mappings = new MappingTree();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public LocalMappingRepository(@Fit JsonSerializer serializer, @Fit(alias="rest-config.loader.json") RestMappingLoader loader, @Fit RepoConfig conf) {
        this.serializer = (JsonSerializer)Validation.notNull((Object)serializer, (String)"The JSON serializer cannot be null.", (Object[])new Object[0]);
        this.loader = (RestMappingLoader)Validation.notNull((Object)loader, (String)"The REST mapping loader cannot be null.", (Object[])new Object[0]);
        this.conf = (RepoConfig)Validation.notNull((Object)conf, (String)"The configuration for repo cannot be null.", (Object[])new Object[0]);
        this.signatures = new HashMap<File, String>();
    }

    @PostConstruct
    public void initialize() {
        this.loadMappings();
        this.executor.scheduleAtFixedRate(this::refresh, this.conf.refresh().interval(), this.conf.refresh().interval(), TimeUnit.SECONDS);
    }

    private void refresh() {
        try {
            this.loadMappings();
        }
        catch (Exception e) {
            log.error("Fail to refresh rest-mappings. [error={}]", (Object)e.getMessage());
            log.debug(ExceptionUtils.getReason((Throwable)e), (Throwable)e);
        }
    }

    private void loadMappings() {
        Arrays.stream((Object[])ObjectUtils.nullIf((Object)this.conf.restMappings().directory().listFiles(), (Object)new File[0])).filter(this::isRepoFile).forEach(this::loadMappings);
    }

    private boolean isRepoFile(File file) {
        return StringUtils.endsWithIgnoreCase((String)file.getName(), (String)this.conf.restMappings().extension());
    }

    private void loadMappings(File file) {
        String signature = ValueUtils.digest(file, this.conf.digest().algorithm(), this.conf.digest().bufferSize());
        if (!this.signatures.containsKey(file)) {
            log.info("Load rest-mappings from file. [path={}]", (Object)FileUtils.path((File)file));
            this.loadFile(file).forEach(this.mappings::insert);
            this.signatures.put(file, signature);
        } else if (StringUtils.equals((String)this.signatures.get(file), (String)signature)) {
            log.debug("File not changed. Skip to load rest-mappings. [file={}]", (Object)FileUtils.path((File)file));
        } else {
            log.info("File changed. Reload rest-mappings. [file={}]", (Object)FileUtils.path((File)file));
            this.loadFile(file).forEach(this.mappings::insert);
            this.signatures.put(file, signature);
        }
    }

    private List<RestMapping> loadFile(File file) {
        ArrayList<RestMapping> newMappings = new ArrayList<RestMapping>();
        try (FileInputStream in = new FileInputStream(file);){
            Map values = (Map)this.serializer.deserialize(IoUtils.read((InputStream)in), (Type)VALUES_TYPE);
            this.collectMappings(newMappings, values.values());
        }
        catch (SerializationException | IOException e) {
            log.warn("Fail to load mappings from repo file. [path={}]", (Object)FileUtils.path((File)file));
            log.debug("Fail to load mappings from repo file.", e);
            return newMappings;
        }
        return newMappings;
    }

    private void collectMappings(List<RestMapping> cache, Collection<String> jsons) throws IOException {
        for (String json : jsons) {
            cache.addAll(this.loader.load(json));
        }
    }

    @Override
    public Optional<RestMapping> get(String requestUri, HttpMethod httpMethod) {
        return this.mappings.query(requestUri, httpMethod);
    }
}

