/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.plugin.gateway.repository.RepoConfig;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class MappingRepositoryFactory
implements MappingRepository.Factory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MappingRepositoryFactory.class);
    private final MappingRepository repo;

    public MappingRepositoryFactory(@Fit Map<String, MappingRepository> repos, @Fit RepoConfig conf) {
        ArrayList active = new ArrayList();
        List actual = conf.restMappings().active().stream().filter(Objects::nonNull).map(alias -> {
            MappingRepository availableRepo = (MappingRepository)repos.get(alias);
            if (availableRepo != null) {
                active.add(alias);
            }
            return availableRepo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("Mapping repositories found as active. [active=[{}]]", active);
        this.repo = (requestUri, httpMethod) -> {
            for (MappingRepository repository : actual) {
                Optional<RestMapping> mapping = repository.get(requestUri, httpMethod);
                if (!mapping.isPresent()) continue;
                return mapping;
            }
            return Optional.empty();
        };
    }

    @Override
    public MappingRepository get() {
        return this.repo;
    }
}

