/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.plugin.gateway.repository.MappingTree;
import com.huawei.fit.plugin.gateway.repository.RestMappingLoader;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.PluginBrief;
import com.huawei.fitframework.runtime.PluginStartedObserver;
import com.huawei.fitframework.runtime.SystemDirectories;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;

@Fitable
@Alias(value="mapping-repository.embedded")
public class ResourceMappingRepository
implements MappingRepository,
PluginStartedObserver {
    private static final String REST_MAPPING_YML = "rest-mapping.yml";
    private final MappingTree mappingTree = new MappingTree();
    private final RestMappingLoader loader;

    public ResourceMappingRepository(@Fit(alias="rest-config.loader.yaml") RestMappingLoader loader) {
        this.loader = loader;
    }

    @PostConstruct
    public void postConstruct() {
        List<RestMapping> restMappings = SystemDirectories.allPlugins().stream().filter(Objects::nonNull).map(this::getSinglePluginConfig).flatMap(Collection::stream).collect(Collectors.toList());
        this.checkDuplicated(restMappings);
        restMappings.forEach(this.mappingTree::insert);
    }

    @Override
    public Optional<RestMapping> get(String requestUri, HttpMethod httpMethod) {
        return this.mappingTree.query(requestUri, httpMethod);
    }

    private List<RestMapping> getSinglePluginConfig(SystemDirectories.Plugin plugin) {
        File restMappingConfig = plugin.conf().toPath().resolve(REST_MAPPING_YML).toFile();
        if (restMappingConfig.isFile()) {
            try {
                return this.loader.load(restMappingConfig);
            }
            catch (IOException ex) {
                throw new IllegalStateException(StringUtils.format((String)"Failed to load REST mappings from file. [path={0}]", (Object[])new Object[]{FileUtils.path((File)restMappingConfig)}));
            }
        }
        File[] libs = plugin.lib().listFiles();
        if (libs == null) {
            return Collections.emptyList();
        }
        return Stream.of(libs).filter(Objects::nonNull).filter(File::isFile).filter(FileUtils::isJar).map(this::getSinglePluginConfigFromResource).findFirst().orElseGet(Collections::emptyList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<RestMapping> getSinglePluginConfigFromResource(File lib) {
        try (JarFile jar = new JarFile(lib);){
            JarEntry entry = jar.getJarEntry(REST_MAPPING_YML);
            if (entry != null) {
                try (InputStream in = jar.getInputStream(entry);){
                    List<RestMapping> list = this.loader.load(in);
                    return list;
                }
            }
            List<RestMapping> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to parse rest-mapping from Jar. [file={0}]", (Object[])new Object[]{lib.getName()}), e);
        }
    }

    private void checkDuplicated(List<RestMapping> allMappings) {
        HashSet<RestMapping> set = new HashSet<RestMapping>();
        for (RestMapping singleMapping : allMappings) {
            if (set.contains(singleMapping)) {
                throw new IllegalStateException(StringUtils.format((String)"Rest mapping is duplicated. [DuplicatedMapping: uri={0}, method={1}]", (Object[])new Object[]{singleMapping.getUri(), singleMapping.getMethod().name()}));
            }
            set.add(singleMapping);
        }
    }

    public void onPluginStarted(PluginBrief plugin) {
        SystemDirectories.Plugin pluginDirectory = SystemDirectories.getPlugin((File)plugin.getFile());
        List<RestMapping> restMappings = this.getSinglePluginConfig(pluginDirectory);
        this.checkDuplicated(restMappings);
        restMappings.forEach(this.mappingTree::insert);
    }
}

