/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.repository.support;

import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.enums.HttpParamType;
import com.huawei.fit.plugin.gateway.repository.RestMappingLoader;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.YamlSerializer;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Alias(value="rest-config.loader.yaml")
public class YamlRestConfigLoader
implements RestMappingLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlRestConfigLoader.class);
    private static final Pattern PARAM_PATTERN = Pattern.compile("^\\$\\[(\\d+)]((\\.[^.]+)*)$");
    private final YamlSerializer serializer;

    public YamlRestConfigLoader(@Fit YamlSerializer serializer) {
        this.serializer = (YamlSerializer)Validation.notNull((Object)serializer, (String)"The serializer for yaml cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public List<RestMapping> load(InputStream in) {
        Map values = this.serializer.deserialize(in);
        List config = YamlRestConfigLoader.child(values, "genericables", Collections.emptyList());
        return config.stream().map(YamlRestConfigLoader::load).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<RestMapping> load(Map<String, Object> section) {
        String genericableId = YamlRestConfigLoader.child(section, "id", "");
        Map<String, Object> restConfigs = YamlRestConfigLoader.child(section, "rest", Collections.emptyMap());
        String type = (String)YamlRestConfigLoader.child(restConfigs, "type");
        List mappings = YamlRestConfigLoader.child(restConfigs, "mappings", Collections.emptyList());
        return mappings.stream().map(mapping -> YamlRestConfigLoader.load(genericableId, type, mapping)).collect(Collectors.toList());
    }

    private static RestMapping load(String genericableId, String type, Map<String, Object> values) {
        RestMapping mapping = RestMapping.builder().uri(Validation.notBlank((String)((String)YamlRestConfigLoader.child(values, "uri")), (String)"", (Object[])new Object[0])).genericId(genericableId).method(HttpMethod.from((String)YamlRestConfigLoader.child(values, "method"))).httpType(type).paramMappings(YamlRestConfigLoader.child(values, "params", Collections.emptyList()).stream().map(YamlRestConfigLoader::param).collect(Collectors.toList())).responseTemplate(YamlRestConfigLoader.child(values, "responseTemplate", "")).build();
        log.debug("REST mapping loaded. [uri={}, method={}, genericable={}]", new Object[]{mapping.getUri(), mapping.getMethod().name(), mapping.getGenericId()});
        return mapping;
    }

    private static ParamMapping param(Map<String, Object> values) {
        String param = (String)YamlRestConfigLoader.child(values, "param");
        Matcher matcher = (Matcher)ObjectUtils.mapIfNotNull((Object)param, PARAM_PATTERN::matcher);
        if (matcher == null || !matcher.find()) {
            throw new IllegalStateException(StringUtils.format((String)"Invalid param of REST mapping. [param={0}]", (Object[])new Object[]{param}));
        }
        return ParamMapping.builder().from(HttpParamType.valueOf((String)YamlRestConfigLoader.child(values, "from"))).fromKey((String)YamlRestConfigLoader.child(values, "key")).defaultValue((String)YamlRestConfigLoader.child(values, "default-value")).index((Integer)ObjectUtils.mapIfNotNull((Object)matcher, nonNull -> Integer.parseInt(nonNull.group(1)))).toKey((String)ObjectUtils.mapIfNotNull((Object)matcher, nonNull -> StringUtils.trimStart((String)nonNull.group(2), (char)'.'))).to(ParamTypeEnum.getOrDefault((String)YamlRestConfigLoader.child(values, "param-type"))).build();
    }

    private static <T> T child(Map<String, Object> values, String key) {
        Object value = values.get(key);
        return (T)value;
    }

    private static <T> T child(Map<String, Object> values, String key, T defaultValue) {
        return (T)ObjectUtils.nullIf(YamlRestConfigLoader.child(values, key), defaultValue);
    }
}

