/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.servlet;

import com.huawei.fit.hakuna.kernel.broker.client.GenericDownload;
import com.huawei.fit.hakuna.kernel.broker.client.GenericInvokeV2;
import com.huawei.fit.hakuna.system.file.downloader.client.DownloadV2;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fit.plugin.gateway.repository.MappingRepository;
import com.huawei.fit.plugin.gateway.workflow.AfterFluentDownloadNode;
import com.huawei.fit.plugin.gateway.workflow.BeforeExecuteNode;
import com.huawei.fit.plugin.gateway.workflow.BeforeExtractHttpBodyNode;
import com.huawei.fit.plugin.gateway.workflow.DownloadNode;
import com.huawei.fit.plugin.gateway.workflow.ExecuteNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractContextNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractHttpBinaryBodyNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractHttpMultipartBodyNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractHttpRawBodyNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractParamNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractPathVariableNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractSystemHeaderNode;
import com.huawei.fit.plugin.gateway.workflow.ExtractTimeoutNode;
import com.huawei.fit.plugin.gateway.workflow.FluentDownloadNode;
import com.huawei.fit.plugin.gateway.workflow.GenerateRequestIdNode;
import com.huawei.fit.plugin.gateway.workflow.MappingNode;
import com.huawei.fit.plugin.gateway.workflow.WriteFileNode;
import com.huawei.fit.plugin.gateway.workflow.WriteResponseNode;
import com.huawei.fit.plugin.gateway.workflow.service.FluentDownloadCache;
import com.huawei.fit.plugin.gateway.workflow.service.HttpRequestExtractor;
import com.huawei.fit.plugin.gateway.workflow.service.HttpResponseHandler;
import com.huawei.fit.plugin.gateway.workflow.service.WebExceptionHandler;
import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.server.http.FitServletSupplier;
import com.huawei.fitframework.broker.server.http.RequestMapping;
import com.huawei.fitframework.core.common.util.MapBuilder;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Node;
import com.huawei.fitframework.workflow.Workflow;
import com.huawei.fitframework.workflow.support.DefaultStartNode;
import com.huawei.fitframework.workflow.support.DefaultStopNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@RequestMapping(value="/*")
public class DispatchServlet
extends HttpServlet
implements FitServletSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DispatchServlet.class);
    private final MappingRepository mappingRepository;
    private final GenericDownload genericDownload;
    private final GenericInvokeV2 genericInvoke;
    private final PutGlobalContext putGlobalContext;
    private final RemoveGlobalContext removeGlobalContext;
    private final JsonSerializer jsonSerializer;
    private final FluentDownloadCache fluentDownloadCache;
    private final DownloadV2 clientDownloader;
    private final HttpRequestExtractor httpRequestExtractor;
    private final HttpResponseHandler httpResponseHandler;
    private final WebExceptionHandler webExceptionHandler;
    private final ConfigurationLoader configurationLoader;
    private final int timeToLive;
    private final List<String> headersWithTtl;
    private final int defaultErrorCode;
    private final int maxHeaderLength;
    private final long maxExecutionTimeout;
    private final String whiteHeaders;
    private Workflow workflow;

    public DispatchServlet(@Fit MappingRepository.Factory repoFactory, @Fit GenericDownload genericDownload, @Fit GenericInvokeV2 genericInvoke, @Fit PutGlobalContext putGlobalContext, @Fit RemoveGlobalContext removeGlobalContext, @Fit JsonSerializer jsonSerializer, @Fit FluentDownloadCache fluentDownloadCache, @Fit HttpRequestExtractor httpRequestExtractor, @Fit HttpResponseHandler httpResponseHandler, @Fit DownloadV2 clientDownloader, @Fit WebExceptionHandler webExceptionHandler, @Value(value="${server.transmission.time-to-live}") Integer timeToLive, @Value(value="${server.transmission.headers}") List<String> headersWithTtl, @Value(value="${server.error.default-code}") Integer defaultCode, @Value(value="${server.allowed.max-header-length}") Integer maxHeaderLength, @Value(value="${server.allowed.max-execution-timeout}") Long maxExecutionTimeout, @Value(value="${server.transmission.white-headers}") String whiteHeaders, @Fit ConfigurationLoader configurationLoader) {
        this.mappingRepository = MappingRepository.get(repoFactory);
        this.genericDownload = genericDownload;
        this.genericInvoke = genericInvoke;
        this.putGlobalContext = putGlobalContext;
        this.removeGlobalContext = removeGlobalContext;
        this.jsonSerializer = jsonSerializer;
        this.fluentDownloadCache = fluentDownloadCache;
        this.httpRequestExtractor = httpRequestExtractor;
        this.httpResponseHandler = httpResponseHandler;
        this.clientDownloader = clientDownloader;
        this.webExceptionHandler = webExceptionHandler;
        this.configurationLoader = configurationLoader;
        this.timeToLive = (Integer)Validation.notNull((Object)timeToLive, (String)"No time-to-live config. [config=server.transmission.time-to-live]", (Object[])new Object[0]);
        this.headersWithTtl = headersWithTtl;
        this.defaultErrorCode = (Integer)Validation.notNull((Object)defaultCode, (String)"No default-code config. [config=server.error.default-code]", (Object[])new Object[0]);
        this.maxHeaderLength = (Integer)Validation.notNull((Object)maxHeaderLength, (String)"No max-header-length config. [config=server.allowed.max-header-length]", (Object[])new Object[0]);
        this.maxExecutionTimeout = (Long)Validation.notNull((Object)maxExecutionTimeout, (String)"No max-execution-timeout config. [config=server.allowed.max-execution-timeout]", (Object[])new Object[0]);
        this.whiteHeaders = whiteHeaders;
        this.constructWorkflow();
    }

    private void constructWorkflow() {
        Map<String, Node> nodes = this.constructNodes();
        this.workflow = Workflow.builder().name("Rest Gateway").addLine(nodes.get("Start"), nodes.get("Rest Mapping")).addLine(nodes.get("Rest Mapping"), nodes.get("Extract System Headers")).addLine(nodes.get("Extract System Headers"), nodes.get("Extract Path Variables")).addLine(nodes.get("Extract Path Variables"), nodes.get("Before Extract Http Body")).addLine(nodes.get("Before Extract Http Body"), nodes.get("Extract Http Multipart Body"), this::isNextExtractHttpMultipartBodyNode).addLine(nodes.get("Before Extract Http Body"), nodes.get("Extract Http Raw Body"), this::isNextExtractHttpRawBodyNode).addLine(nodes.get("Before Extract Http Body"), nodes.get("Extract Http Binary Body"), this::isNextExtractHttpBinaryBodyNode).addLine(nodes.get("Before Extract Http Body"), nodes.get("Extract Genericable Params"), this::isNextExtractParamNode).addLine(nodes.get("Extract Http Multipart Body"), nodes.get("Extract Genericable Params")).addLine(nodes.get("Extract Http Raw Body"), nodes.get("Extract Genericable Params")).addLine(nodes.get("Extract Http Binary Body"), nodes.get("Extract Genericable Params")).addLine(nodes.get("Extract Genericable Params"), nodes.get("Extract Context")).addLine(nodes.get("Extract Context"), nodes.get("Extract Timeout")).addLine(nodes.get("Extract Timeout"), nodes.get("Before Execute")).addLine(nodes.get("Before Execute"), nodes.get("Download"), this::isNextDownloadNode).addLine(nodes.get("Before Execute"), nodes.get("Generate RequestId"), this::isNextGenerateRequestIdNode).addLine(nodes.get("Before Execute"), nodes.get("Execute"), this::isNextExecuteNode).addLine(nodes.get("Download"), nodes.get("Write File")).addLine(nodes.get("Execute"), nodes.get("Write Response")).addLine(nodes.get("Write File"), nodes.get("Stop")).addLine(nodes.get("Write Response"), nodes.get("Stop")).addLine(nodes.get("Generate RequestId"), nodes.get("Fluent Download")).addLine(nodes.get("Fluent Download"), nodes.get("After Fluent Download")).addLine(nodes.get("After Fluent Download"), nodes.get("Write Response"), this::isNextWriteResponseNode).addLine(nodes.get("After Fluent Download"), nodes.get("Stop"), this::isNextDefaultStopNode).build();
    }

    private boolean isNextDefaultStopNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nodeName, "Stop");
    }

    private boolean isNextWriteResponseNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nodeName, "Write Response");
    }

    private boolean isNextExecuteNode(Input input) {
        String nextNodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nextNodeName, "Execute");
    }

    private boolean isNextGenerateRequestIdNode(Input input) {
        String nextNodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nextNodeName, "Fluent Download");
    }

    private boolean isNextDownloadNode(Input input) {
        String nextNodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nextNodeName, "Download");
    }

    private boolean isNextExtractParamNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return StringUtils.isBlank((String)nodeName);
    }

    private boolean isNextExtractHttpBinaryBodyNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nodeName, "Extract Http Binary Body");
    }

    private boolean isNextExtractHttpRawBodyNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nodeName, "Extract Http Raw Body");
    }

    private boolean isNextExtractHttpMultipartBodyNode(Input input) {
        String nodeName = (String)input.get("nextNodeName", String.class);
        return Objects.equals(nodeName, "Extract Http Multipart Body");
    }

    private Map<String, Node> constructNodes() {
        return MapBuilder.get().put((Object)"Start", (Object)new DefaultStartNode()).put((Object)"Stop", (Object)new DefaultStopNode()).put((Object)"Rest Mapping", (Object)new MappingNode(this.mappingRepository)).put((Object)"Extract System Headers", (Object)new ExtractSystemHeaderNode(this.maxHeaderLength)).put((Object)"Extract Path Variables", (Object)new ExtractPathVariableNode()).put((Object)"Before Extract Http Body", (Object)new BeforeExtractHttpBodyNode()).put((Object)"Extract Http Multipart Body", (Object)new ExtractHttpMultipartBodyNode(this.httpRequestExtractor)).put((Object)"Extract Http Raw Body", (Object)new ExtractHttpRawBodyNode(this.httpRequestExtractor)).put((Object)"Extract Http Binary Body", (Object)new ExtractHttpBinaryBodyNode(this.httpRequestExtractor)).put((Object)"Extract Genericable Params", (Object)new ExtractParamNode(this.httpRequestExtractor, this.jsonSerializer)).put((Object)"Extract Context", (Object)new ExtractContextNode(this.httpRequestExtractor, this.jsonSerializer)).put((Object)"Extract Timeout", (Object)new ExtractTimeoutNode(this.maxExecutionTimeout)).put((Object)"Execute", (Object)new ExecuteNode(this.putGlobalContext, this.removeGlobalContext, this.jsonSerializer, this.genericInvoke, this.httpResponseHandler, this.webExceptionHandler, this.defaultErrorCode, this.whiteHeaders)).put((Object)"Download", (Object)new DownloadNode(this.putGlobalContext, this.removeGlobalContext, this.jsonSerializer, this.genericDownload, this.httpResponseHandler, this.defaultErrorCode, this.whiteHeaders)).put((Object)"Generate RequestId", (Object)new GenerateRequestIdNode()).put((Object)"Fluent Download", (Object)new FluentDownloadNode(this.putGlobalContext, this.removeGlobalContext, this.jsonSerializer, this.fluentDownloadCache, this.clientDownloader, this.webExceptionHandler, this.httpResponseHandler, this.whiteHeaders)).put((Object)"After Fluent Download", (Object)new AfterFluentDownloadNode()).put((Object)"Write Response", (Object)new WriteResponseNode()).put((Object)"Write File", (Object)new WriteFileNode()).put((Object)"Before Execute", (Object)new BeforeExecuteNode(this.configurationLoader)).build();
    }

    public Servlet servlet() {
        return this;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpMethod httpMethod = HttpMethod.from(request.getMethod());
        if (httpMethod == HttpMethod.PATCH) {
            this.handleRequest(request, response);
        } else {
            super.service(request, response);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpMethod requestMethod = HttpMethod.from(request.getMethod());
        Optional<RestMapping> restMappingOptional = this.mappingRepository.get(request.getRequestURI(), requestMethod);
        if (!restMappingOptional.isPresent()) {
            response.sendError(404);
            return;
        }
        RestMapping restMapping = restMappingOptional.get();
        HttpMethod allowHttpMethod = restMapping.getMethod();
        response.setHeader("Allow", allowHttpMethod.name());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Input input = Input.builder().put("request", (Object)request).put("response", (Object)response).put("servletContext", (Object)this.getServletContext()).put("headersWithTtl", this.headersWithTtl).put("timeToLive", (Object)this.timeToLive).build();
            this.workflow.create().start(input);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }
}

