/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.utils;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class ValueUtils {
    private ValueUtils() {
    }

    public static <K, V, R> R get(Map<K, V> values, K key) {
        return (R)ValueUtils.cast(ObjectUtils.mapIfNotNull(values, map -> map.get(key)));
    }

    public static <T> T cast(Object value) {
        Object actual = value;
        return (T)actual;
    }

    public static String digest(File file, String algorithm, int bufferSize) {
        byte[] data;
        MessageDigest digest;
        Validation.notNull((Object)file, (String)"The file to compute digest cannot be null.", (Object[])new Object[0]);
        Validation.notBlank((String)algorithm, (String)"The algorithm to compute digest cannot be null.", (Object[])new Object[0]);
        Validation.greaterThan((int)bufferSize, (int)0, (String)"The buffer size to compute digest must be positive.", (Object[])new Object[0]);
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(StringUtils.format((String)"Digest algorithm not found. [algorithm={0}]", (Object[])new Object[]{algorithm}), ex);
        }
        try (FileInputStream in = new FileInputStream(file);){
            int part;
            int total = (int)file.length();
            byte[] buffer = new byte[bufferSize];
            for (int read = 0; read < total; read += part) {
                part = ((InputStream)in).read(buffer, 0, buffer.length);
                digest.update(buffer, 0, part);
            }
            data = digest.digest();
        }
        catch (IOException ex) {
            throw new IllegalStateException(StringUtils.format((String)"Failed to read file to compute digest. [file={0}, error={1}]", (Object[])new Object[]{FileUtils.path((File)file), ex.getMessage()}), ex);
        }
        return ValueUtils.hex(data);
    }

    private static String hex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte aByte : data) {
            ValueUtils.appendHex(builder, aByte);
        }
        return builder.toString();
    }

    private static void appendHex(StringBuilder builder, byte value) {
        int intValue = Byte.toUnsignedInt(value);
        ValueUtils.appendSingleHex(builder, intValue >> 4 & 0xF);
        ValueUtils.appendSingleHex(builder, intValue & 0xF);
    }

    private static void appendSingleHex(StringBuilder builder, int value) {
        if (value < 10) {
            builder.append((char)(value + 48));
        } else {
            builder.append((char)(value - 10 + 97));
        }
    }
}

