/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.workflow.AbstractConditionalNode;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeExecuteNode
extends AbstractConditionalNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeforeExecuteNode.class);
    public static final String NAME = "Before Execute";
    private final ConfigurationLoader configurationLoader;

    public BeforeExecuteNode(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        Collection genericableTags = this.configurationLoader.load().genericable(restMapping.getGenericId()).map(GenericableConfiguration::tags).orElseGet(Collections::emptyList);
        boolean isContainsFluentDownloadTag = genericableTags.contains("Streaming Download");
        boolean isContainsDownloadTag = genericableTags.contains("Download");
        if (isContainsDownloadTag && isContainsFluentDownloadTag) {
            throw new IllegalStateException(StringUtils.format((String)"The {0} and {1} tags cannot exist at the same time.", (Object[])new Object[]{"Download", "Streaming Download"}));
        }
        if (isContainsDownloadTag) {
            log.debug("Execute download process");
            return Output.builder().put("nextNodeName", (Object)"Download").build();
        }
        if (isContainsFluentDownloadTag) {
            log.debug("Execute fluent download process");
            return Output.builder().put("nextNodeName", (Object)"Fluent Download").build();
        }
        String httpType = restMapping.getHttpType();
        if (StringUtils.isBlank((String)httpType)) {
            log.debug("Execute normal process");
            return Output.builder().put("nextNodeName", (Object)"Execute").build();
        }
        if (Objects.equals(httpType, "download")) {
            log.debug("Execute download process");
            return Output.builder().put("nextNodeName", (Object)"Download").build();
        }
        if (Objects.equals(httpType, "fluentDownload")) {
            log.debug("Execute fluent download process");
            return Output.builder().put("nextNodeName", (Object)"Fluent Download").build();
        }
        log.debug("Execute normal process");
        return Output.builder().put("nextNodeName", (Object)"Execute").build();
    }
}

