/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.enums.HttpMethod;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.workflow.AbstractConditionalNode;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import javax.servlet.http.HttpServletRequest;

public class BeforeExtractHttpBodyNode
extends AbstractConditionalNode {
    public static final String NAME = "Before Extract Http Body";
    private static final String CONTENT_TYPE_APP_BINARY = "application/octet\u2011stream";
    private static final String CONTENT_TYPE_APP_JSON = "application/json";
    private static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String CONTENT_TYPE_MULTIPART_MIXED = "multipart/mixed";

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        if (this.notContainsBody(HttpMethod.from(request.getMethod()))) {
            return Output.empty();
        }
        if (this.isMultipart(request)) {
            return Output.builder().put("nextNodeName", (Object)"Extract Http Multipart Body").build();
        }
        if (this.isRaw(request)) {
            return Output.builder().put("nextNodeName", (Object)"Extract Http Raw Body").build();
        }
        if (this.isBinary(request)) {
            return Output.builder().put("nextNodeName", (Object)"Extract Http Binary Body").build();
        }
        return Output.empty();
    }

    private boolean notContainsBody(HttpMethod requestMethod) {
        return requestMethod == HttpMethod.GET || requestMethod == HttpMethod.DELETE;
    }

    private boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        return StringUtils.isNotBlank((String)contentType) && (contentType.contains(CONTENT_TYPE_MULTIPART_FORM_DATA) || contentType.contains(CONTENT_TYPE_MULTIPART_MIXED));
    }

    private boolean isRaw(HttpServletRequest request) {
        String contentType = request.getContentType();
        return StringUtils.isNotBlank((String)contentType) && contentType.contains(CONTENT_TYPE_APP_JSON);
    }

    private boolean isBinary(HttpServletRequest request) {
        String contentType = request.getContentType();
        return StringUtils.isNotBlank((String)contentType) && contentType.contains(CONTENT_TYPE_APP_BINARY);
    }
}

