/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.broker.server.entity.FileDescriptor;
import com.huawei.fit.hakuna.kernel.broker.client.GenericDownload;
import com.huawei.fit.hakuna.kernel.broker.client.entity.GenericInvokeContext;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.workflow.GlobalContextActivity;
import com.huawei.fit.plugin.gateway.workflow.service.HttpResponseHandler;
import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadNode
extends GlobalContextActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadNode.class);
    public static final String NAME = "Download";
    public static final String TAG = "Download";
    private final GenericDownload genericDownload;
    private final HttpResponseHandler responseHandler;
    private final int defaultErrorCode;

    public DownloadNode(PutGlobalContext putGlobalContext, RemoveGlobalContext removeGlobalContext, JsonSerializer jsonSerializer, GenericDownload genericDownload, HttpResponseHandler responseHandler, int defaultErrorCode, String whiteHeaders) {
        super(putGlobalContext, removeGlobalContext, jsonSerializer, whiteHeaders);
        this.genericDownload = genericDownload;
        this.responseHandler = responseHandler;
        this.defaultErrorCode = defaultErrorCode;
    }

    public String getName() {
        return "Download";
    }

    public Output process(Input input) {
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        String genericableId = restMapping.getGenericId();
        try {
            FileDescriptor fileDescriptor = this.download(genericableId, input).orElse(null);
            return Output.builder().put("code", (Object)200).put("file", (Object)fileDescriptor).build();
        }
        catch (Exception ex) {
            String data = this.responseHandler.handleError(genericableId, ex, restMapping);
            return Output.builder().put("code", (Object)this.defaultErrorCode).put("data", (Object)data).build();
        }
    }

    private Optional<FileDescriptor> download(String genericableId, Input input) {
        List params = (List)input.require("params", List.class);
        log.debug("Prepare to download file. [genericableId={}, params={}]", (Object)genericableId, (Object)params);
        String alias = (String)input.get("alias", String.class);
        String workerId = (String)input.get("workerId", String.class);
        long timeout = (Long)ObjectUtils.nullIf((Object)input.get("timeout", Long.class), (Object)InvokeContext.defaultContext().timeout());
        long retry = (Long)ObjectUtils.nullIf((Object)input.get("retry", Long.class), (Object)0L);
        GenericInvokeContext genericInvokeContext = GenericInvokeContext.builder().genericableId(genericableId).params(params).alias(alias).workerId(workerId).timeout(Long.valueOf(timeout)).retry(Long.valueOf(retry)).build();
        FileDescriptor file = this.genericDownload.process(genericInvokeContext);
        if (file == null) {
            log.warn("No file need to download. [genericableId={}]", (Object)genericableId);
            return Optional.empty();
        }
        Validation.notBlank((String)file.getFileName(), (String)"No downloaded filename. [genericableId={0}]", (Object[])new Object[]{genericableId});
        Validation.notNull((Object)file.getFileContent(), (String)"No downloaded file content. [genericableId={0}, filename={1}]", (Object[])new Object[]{genericableId, file.getFileName()});
        log.debug("Download file successfully. [filename={}, contentLength={}]", (Object)file.getFileName(), (Object)file.getFileContent().length);
        return Optional.of(file);
    }
}

