/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.hakuna.kernel.broker.client.GenericInvokeV2;
import com.huawei.fit.hakuna.kernel.broker.client.entity.GenericInvokeContext;
import com.huawei.fit.hakuna.system.exception.entity.WebResponse;
import com.huawei.fit.hakuna.system.shared.entity.StringResponse;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.workflow.GlobalContextActivity;
import com.huawei.fit.plugin.gateway.workflow.service.HttpResponseHandler;
import com.huawei.fit.plugin.gateway.workflow.service.WebExceptionHandler;
import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteNode
extends GlobalContextActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteNode.class);
    public static final String NAME = "Execute";
    private final GenericInvokeV2 genericInvoke;
    private final HttpResponseHandler responseHandler;
    private final WebExceptionHandler webExceptionHandler;
    private final int defaultErrorCode;

    public ExecuteNode(PutGlobalContext putGlobalContext, RemoveGlobalContext removeGlobalContext, JsonSerializer jsonSerializer, GenericInvokeV2 genericInvoke, HttpResponseHandler responseHandler, WebExceptionHandler webExceptionHandler, int defaultErrorCode, String whiteHeaders) {
        super(putGlobalContext, removeGlobalContext, jsonSerializer, whiteHeaders);
        this.genericInvoke = genericInvoke;
        this.responseHandler = responseHandler;
        this.webExceptionHandler = webExceptionHandler;
        this.defaultErrorCode = defaultErrorCode;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        String genericableId = restMapping.getGenericId();
        try {
            String result = this.route(genericableId, restMapping, input);
            return Output.builder().put("code", (Object)200).put("data", (Object)result).build();
        }
        catch (Exception ex) {
            if (this.webExceptionHandler.isWebException(ex)) {
                return this.handleWebException(input, (FitException)ObjectUtils.cast((Object)ex), restMapping);
            }
            return this.handleException(restMapping, genericableId, ex);
        }
    }

    private Output handleWebException(Input input, FitException webException, RestMapping restMapping) {
        try {
            WebResponse webResponse = this.webExceptionHandler.handle(input, webException);
            return Output.builder().put("code", (Object)webResponse.getHttpCode()).put("data", (Object)webResponse.getResponseBody()).put("responseHeaders", (Object)webResponse.getResponseHeaders()).build();
        }
        catch (Exception e) {
            log.error("Fail to handle web exception. [handled exception code={}, handled exception msg={}]", (Object)webException.getCode(), (Object)webException.getMessage());
            log.debug(e.getClass().getName(), (Throwable)e);
            return this.handleException(restMapping, restMapping.getGenericId(), (Exception)webException);
        }
    }

    private Output handleException(RestMapping restMapping, String genericableId, Exception ex) {
        String result = this.responseHandler.handleError(genericableId, ex, restMapping);
        return Output.builder().put("code", (Object)this.defaultErrorCode).put("data", (Object)result).build();
    }

    private String route(String genericableId, RestMapping restMapping, Input input) {
        List params = (List)input.get("params", List.class);
        log.debug("Prepare to execute. [genericableId={}, params={}]", (Object)genericableId, (Object)params);
        GenericInvokeContext genericInvokeContext = this.getGenericInvokeContext(genericableId, params, input);
        StringResponse stringResponse = (StringResponse)Validation.notNull((Object)this.genericInvoke.process(genericInvokeContext), (String)StringUtils.format((String)"The response of generic invocation is null. [genericableId={0}]", (Object[])new Object[]{genericableId}), (Object[])new Object[0]);
        String response = this.responseHandler.convertResponse(stringResponse, restMapping);
        return this.responseHandler.handleCorrectResponse(genericableId, response);
    }

    private GenericInvokeContext getGenericInvokeContext(String genericId, List<String> params, Input input) {
        long timeout = (Long)ObjectUtils.nullIf((Object)input.get("timeout", Long.class), (Object)InvokeContext.defaultContext().timeout());
        String alias = (String)input.get("alias", String.class);
        String workerId = (String)input.get("workerId", String.class);
        Long retry = (Long)ObjectUtils.nullIf((Object)input.get("retry", Long.class), (Object)0L);
        return GenericInvokeContext.builder().genericableId(genericId).alias(alias).workerId(workerId).timeout(Long.valueOf(timeout)).params(params).retry(retry).build();
    }
}

