/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.entity.HttpContext;
import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.enums.FitHttpHeader;
import com.huawei.fit.plugin.gateway.param.ClassifiedParam;
import com.huawei.fit.plugin.gateway.param.chain.ParamParserChain;
import com.huawei.fit.plugin.gateway.workflow.service.HttpRequestExtractor;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class ExtractContextNode
extends AbstractActivity {
    public static final String NAME = "Extract Context";
    private final HttpRequestExtractor extractor;
    private final JsonSerializer jsonSerializer;

    public ExtractContextNode(HttpRequestExtractor extractor, JsonSerializer jsonSerializer) {
        this.extractor = extractor;
        this.jsonSerializer = jsonSerializer;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        Map systemHeaderMap = (Map)input.get("systemHeader", Map.class);
        HashMap<String, String> contextMap = new HashMap<String, String>();
        String environment = (String)systemHeaderMap.get(FitHttpHeader.ENVIRONMENT.getCode());
        if (StringUtils.isNotBlank((String)environment)) {
            contextMap.put(FitHttpHeader.ENVIRONMENT.getCode(), environment);
            RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
            String genericableId = restMapping.getGenericId();
            contextMap.put("FIT-ENVIRONMENT-GENERICABLE-ID", genericableId);
        }
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        String rawBody = (String)input.get("httpRawBody", String.class);
        List parts = (List)input.get("httpMultipartBody", List.class);
        Map pathVariables = (Map)input.get("pathVariables", Map.class);
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        HttpContext context = HttpContext.builder().request(request).pathVariables(pathVariables).parts(parts).rawBody(rawBody).build();
        List<ParamMapping> paramMappings = restMapping.getParamMappings();
        if (CollectionUtils.isNotEmpty(paramMappings)) {
            contextMap.putAll(this.extractContext(paramMappings, context));
        }
        return Output.builder().put("context", contextMap).build();
    }

    private Map<String, String> extractContext(List<ParamMapping> paramMappings, HttpContext context) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        ClassifiedParam.classifyParams(paramMappings).stream().filter(param -> param.getParamType() == ParamTypeEnum.CONTEXT).forEach(param -> {
            String value = this.convertToString(ParamParserChain.doParse(param, context, this.extractor::extractParam));
            contextMap.put(param.getFirstKey(), value);
        });
        return contextMap;
    }

    private String convertToString(Object result) {
        return Optional.ofNullable(result).map(value -> value instanceof String ? (String)value : this.jsonSerializer.serialize(value)).orElse(null);
    }
}

