/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.entity.HttpContext;
import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.entity.ParamTypeEnum;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.param.ClassifiedParam;
import com.huawei.fit.plugin.gateway.param.chain.ParamParserChain;
import com.huawei.fit.plugin.gateway.workflow.service.HttpRequestExtractor;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractParamNode
extends AbstractActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractParamNode.class);
    public static final String NAME = "Extract Genericable Params";
    private final HttpRequestExtractor extractor;
    private final JsonSerializer jsonSerializer;

    public ExtractParamNode(HttpRequestExtractor extractor, JsonSerializer jsonSerializer) {
        this.extractor = extractor;
        this.jsonSerializer = jsonSerializer;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        List<Object> params;
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        log.debug("Prepare to extract params. [uri={}, method={}, genericable={}]", new Object[]{restMapping.getUri(), restMapping.getMethod().name(), restMapping.getGenericId()});
        String rawBody = (String)input.get("httpRawBody", String.class);
        List parts = (List)input.get("httpMultipartBody", List.class);
        Map pathVariables = (Map)input.get("pathVariables", Map.class);
        HttpContext context = HttpContext.builder().request(request).pathVariables(pathVariables).parts(parts).rawBody(rawBody).build();
        List<ParamMapping> paramMappings = restMapping.getParamMappings();
        if (CollectionUtils.isEmpty(paramMappings)) {
            params = Collections.emptyList();
        } else {
            paramMappings.forEach(paramMapping -> log.debug("param mapping info: {}", (Object)paramMapping.toString()));
            params = this.extractParams(paramMappings, context);
        }
        return Output.builder().put("params", params).build();
    }

    private List<String> extractParams(List<ParamMapping> paramMappings, HttpContext context) {
        List<ClassifiedParam> classifiedParams = ClassifiedParam.classifyParams(paramMappings);
        List<Object> params = Arrays.asList(new Object[this.getParamSize(classifiedParams)]);
        classifiedParams.stream().filter(param -> param.getParamType() == ParamTypeEnum.PARAM).forEach(param -> {
            Object value = ParamParserChain.doParse(param, context, this.extractor::extractParam);
            log.debug("param is set. [index={}, value={}]", (Object)param.getIndex(), value);
            params.set(param.getIndex(), value);
        });
        return params.stream().map(arg_0 -> ((JsonSerializer)this.jsonSerializer).serialize(arg_0)).collect(Collectors.toList());
    }

    private int getParamSize(List<ClassifiedParam> classifiedParams) {
        if (CollectionUtils.isEmpty(classifiedParams)) {
            return 0;
        }
        return classifiedParams.stream().mapToInt(ClassifiedParam::getIndex).max().orElse(-1) + 1;
    }
}

