/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.exception.InvalidPathPatternException;
import com.huawei.fit.plugin.gateway.utils.UriUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.UrlUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class ExtractPathVariableNode
extends AbstractActivity {
    public static final String NAME = "Extract Path Variables";
    private static final char PATH_SEPARATOR = '/';

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        Map<String, String> pathVariables = this.extractPathVariables(restMapping.getUri(), request.getRequestURI());
        return Output.builder().put("pathVariables", pathVariables).build();
    }

    private Map<String, String> extractPathVariables(String pattern, String uri) {
        Validation.isTrue((boolean)pattern.startsWith(String.valueOf('/')), () -> new InvalidPathPatternException(StringUtils.format((String)"No first '{0}' in path pattern. [uri={1}]", (Object[])new Object[]{Character.valueOf('/'), pattern})));
        List patternFragments = StringUtils.splitToList((String)pattern, (char)'/').stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List uriFragments = StringUtils.splitToList((String)uri, (char)'/').stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validation.isTrue((patternFragments.size() == uriFragments.size() ? 1 : 0) != 0, () -> new InvalidPathPatternException(StringUtils.format((String)"Path pattern and uri are not match. [pattern={0}, uri={1}]", (Object[])new Object[]{pattern, uri})));
        HashMap<String, String> pathVariableMap = new HashMap<String, String>();
        for (int i = 0; i < patternFragments.size(); ++i) {
            String patternFragment = (String)patternFragments.get(i);
            String uriFragment = UrlUtils.decode((String)((String)uriFragments.get(i)));
            UriUtils.extractPathVariableName(patternFragment).ifPresent(pathVariable -> pathVariableMap.put((String)pathVariable, uriFragment));
        }
        return pathVariableMap;
    }
}

