/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.enums.FitHttpHeader;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.UrlUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class ExtractSystemHeaderNode
extends AbstractActivity {
    public static final String NAME = "Extract System Headers";
    private final int maxSystemHeaderLength;

    public ExtractSystemHeaderNode(int maxSystemHeaderLength) {
        this.maxSystemHeaderLength = maxSystemHeaderLength;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        HashMap<String, String> fitHeaderMap = new HashMap<String, String>();
        for (FitHttpHeader headerKey : FitHttpHeader.values()) {
            String headerCode = headerKey.getCode();
            String headerValue = request.getHeader(headerCode);
            if (headerValue == null) continue;
            Validation.lessThanOrEquals((int)headerValue.length(), (int)this.maxSystemHeaderLength, (String)"Header is too long. [header={0}]", (Object[])new Object[]{headerCode});
            fitHeaderMap.put(headerCode, headerValue);
        }
        String alias = ExtractSystemHeaderNode.decode((String)fitHeaderMap.get(FitHttpHeader.ALIAS.getCode()));
        String workerId = ExtractSystemHeaderNode.decode((String)fitHeaderMap.get(FitHttpHeader.WORKER_ID.getCode()));
        long retry = Long.parseLong(fitHeaderMap.getOrDefault(FitHttpHeader.RETRY.getCode(), "0"));
        return Output.builder().put("systemHeader", fitHeaderMap).put("alias", (Object)alias).put("workerId", (Object)workerId).put("retry", (Object)retry).build();
    }

    private static String decode(String value) {
        if (StringUtils.isBlank((String)value)) {
            return value;
        }
        return UrlUtils.decode((String)value);
    }
}

