/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.plugin.gateway.enums.FitHttpHeader;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractTimeoutNode
extends AbstractActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractTimeoutNode.class);
    public static final String NAME = "Extract Timeout";
    private static final String CONTEXT_KEY_TIMEOUT = "fit.system.timeout";
    private final long maxExecutionTimeout;

    public ExtractTimeoutNode(long maxExecutionTimeout) {
        this.maxExecutionTimeout = maxExecutionTimeout;
    }

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        Map systemHeaders = (Map)input.require("systemHeader", Map.class);
        Map context = (Map)input.require("context", Map.class);
        long timeout = this.getTimeout(systemHeaders, context);
        return Output.builder().put("timeout", (Object)timeout).build();
    }

    private long getTimeout(Map<String, String> systemHeaders, Map<String, String> context) {
        long timeout = context.containsKey(CONTEXT_KEY_TIMEOUT) ? this.getTimeoutFromContext(context) : (systemHeaders.containsKey(FitHttpHeader.EXECUTION_TIMEOUT.getCode()) ? this.getTimeoutFromHeader(systemHeaders) : InvokeContext.defaultContext().timeout());
        if (timeout > this.maxExecutionTimeout) {
            timeout = this.maxExecutionTimeout;
            log.info("Timeout is greater than MAX timeout config, use max value instead. [customTimeout={}, maxTimeout={}]", (Object)timeout, (Object)this.maxExecutionTimeout);
        }
        return timeout;
    }

    private long getTimeoutFromContext(Map<String, String> context) {
        try {
            return Double.valueOf(Double.parseDouble(context.get(CONTEXT_KEY_TIMEOUT)) * 1000.0).longValue();
        }
        catch (NumberFormatException e) {
            throw new FitException(StringUtils.format((String)"Invalid timeout value in context. [key={0}, timeout={1}]", (Object[])new Object[]{CONTEXT_KEY_TIMEOUT, context.get(CONTEXT_KEY_TIMEOUT)}));
        }
    }

    private long getTimeoutFromHeader(Map<String, String> headers) {
        try {
            return Long.parseLong(headers.get(FitHttpHeader.EXECUTION_TIMEOUT.getCode()));
        }
        catch (NumberFormatException e) {
            throw new FitException(StringUtils.format((String)"Invalid timeout value in header. [key={0}, timeout={1}]", (Object[])new Object[]{FitHttpHeader.EXECUTION_TIMEOUT.getCode(), headers.get(FitHttpHeader.EXECUTION_TIMEOUT.getCode())}));
        }
    }
}

