/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.hakuna.system.exception.entity.WebResponse;
import com.huawei.fit.hakuna.system.file.downloader.client.DownloadV2;
import com.huawei.fit.hakuna.system.file.downloader.client.entity.DownloadRequestV2;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.workflow.GlobalContextActivity;
import com.huawei.fit.plugin.gateway.workflow.service.FluentDownloadCache;
import com.huawei.fit.plugin.gateway.workflow.service.HttpResponseHandler;
import com.huawei.fit.plugin.gateway.workflow.service.WebExceptionHandler;
import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentDownloadNode
extends GlobalContextActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluentDownloadNode.class);
    public static final String NAME = "Fluent Download";
    public static final String TAG = "Streaming Download";
    private final FluentDownloadCache downloadCache;
    private final DownloadV2 clientDownloader;
    private final WebExceptionHandler webExceptionHandler;
    private final HttpResponseHandler responseHandler;

    public FluentDownloadNode(PutGlobalContext putGlobalContext, RemoveGlobalContext removeGlobalContext, JsonSerializer jsonSerializer, FluentDownloadCache downloadCache, DownloadV2 clientDownloader, WebExceptionHandler webExceptionHandler, HttpResponseHandler responseHandler, String whiteHeaders) {
        super(putGlobalContext, removeGlobalContext, jsonSerializer, whiteHeaders);
        this.downloadCache = downloadCache;
        this.clientDownloader = clientDownloader;
        this.webExceptionHandler = webExceptionHandler;
        this.responseHandler = responseHandler;
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output process(Input input) {
        RestMapping restMapping = (RestMapping)input.require("restMapping", RestMapping.class);
        String genericableId = restMapping.getGenericId();
        List params = (List)input.get("params", List.class);
        HttpServletResponse response = (HttpServletResponse)input.require("response", HttpServletResponse.class);
        this.initResponseProperties(response);
        String requestId = (String)input.require("requestId", String.class);
        this.downloadCache.init(requestId, response);
        try {
            String alias = (String)input.get("alias", String.class);
            String workerId = (String)input.get("workerId", String.class);
            long timeout = (Long)ObjectUtils.nullIf((Object)input.get("timeout", Long.class), (Object)InvokeContext.defaultContext().timeout());
            long retry = (Long)ObjectUtils.nullIf((Object)input.get("retry", Long.class), (Object)0L);
            DownloadRequestV2 request = DownloadRequestV2.builder().genericableId(genericableId).params(params.stream().collect(Collectors.joining(",", "[", "]"))).alias(alias).workerId(workerId).timeout(Long.valueOf(timeout)).requestId(requestId).retry(Long.valueOf(retry)).build();
            long deadLine = System.currentTimeMillis() + timeout;
            this.clientDownloader.process(request);
            while (!this.downloadCache.isFinished(requestId)) {
                this.checkTimeout(genericableId, timeout, deadLine);
                ThreadUtils.sleep((long)1L);
            }
            Output output = Output.builder().put("nextNodeName", (Object)"Stop").build();
            return output;
        }
        catch (FitException e) {
            if (this.webExceptionHandler.isWebException((Exception)((Object)e))) {
                WebResponse webResponse = this.webExceptionHandler.handle(input, e);
                Output output = Output.builder().put("nextNodeName", (Object)"Write Response").put("code", (Object)webResponse.getHttpCode()).put("data", (Object)webResponse.getResponseBody()).put("responseHeaders", (Object)webResponse.getResponseHeaders()).build();
                return output;
            }
            Output output = Output.builder().put("code", (Object)500).put("data", (Object)this.responseHandler.handleError(genericableId, e, restMapping)).put("nextNodeName", (Object)"Write Response").build();
            return output;
        }
        finally {
            this.downloadCache.clear(requestId);
        }
    }

    private void initResponseProperties(HttpServletResponse response) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Type", "application/octet-stream");
    }

    private void checkTimeout(String genericableId, long timeout, long deadLine) {
        if (System.currentTimeMillis() > deadLine) {
            String message = StringUtils.format((String)"Fail to download: timeout. [genericableId={0}, timeout={1}]", (Object[])new Object[]{genericableId, timeout});
            throw new FitException(message);
        }
    }
}

