/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.http.entity.HttpRequest;
import com.huawei.fitframework.http.entity.support.DefaultHttpRequest;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalContextActivity
extends AbstractActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalContextActivity.class);
    private static final String TTL_PREFIX = "fit.pass.ttl.";
    private static final String HTTP_REQUEST_URI = "HTTP_REQUEST_URI";
    private static final String HTTP_REMOTE_ADDR = "HTTP_REMOTE_ADDR";
    private static final String HTTP_METHOD = "HTTP_METHOD";
    private static final String HTTP_REQUEST = "HTTP_REQUEST";
    private static final int DEFAULT_TIME_TO_LIVE = 1;
    private final PutGlobalContext putGlobalContext;
    private final RemoveGlobalContext removeGlobalContext;
    private final JsonSerializer jsonSerializer;
    private final Set<String> whiteHeaders;

    protected GlobalContextActivity(PutGlobalContext putGlobalContext, RemoveGlobalContext removeGlobalContext, JsonSerializer jsonSerializer, String whiteHeaders) {
        this.putGlobalContext = putGlobalContext;
        this.removeGlobalContext = removeGlobalContext;
        this.jsonSerializer = jsonSerializer;
        this.whiteHeaders = StringUtils.splitToSet((String)whiteHeaders, (String)",").stream().filter(Objects::nonNull).map(header -> header.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    public void before(Input input) {
        super.before(input);
        this.putHttpGlobalContext(input);
        this.putSourceHttpInfo(input);
    }

    public void after(Input input, Output output) {
        super.after(input, output);
        this.clearHttpGlobalContext(input);
        this.clearSourceHttpInfo(input);
    }

    private void putSourceHttpInfo(Input input) {
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        int ttl = (Integer)ObjectUtils.nullIf((Object)input.get("timeToLive", Integer.class), (Object)1);
        String requestUri = request.getRequestURI();
        this.putGlobalContext(HTTP_REQUEST_URI, requestUri, ttl);
        String remoteAddr = request.getRemoteAddr();
        this.putGlobalContext(HTTP_REMOTE_ADDR, remoteAddr, ttl);
        String method = request.getMethod();
        this.putGlobalContext(HTTP_METHOD, method, ttl);
        List ttlHeaderKeys = (List)ObjectUtils.getIfNull((Object)input.get("headersWithTtl", List.class), Collections::emptyList);
        ttlHeaderKeys.forEach(key -> {
            String value = request.getHeader(key);
            this.putGlobalContext((String)key, value, ttl);
        });
        this.putGlobalContext(HTTP_REQUEST, this.jsonSerializer.serialize(this.objectToMap(this.buildHttpRequest(input))), ttl);
    }

    private HttpRequest buildHttpRequest(Input input) {
        HttpServletRequest request = (HttpServletRequest)input.require("request", HttpServletRequest.class);
        return DefaultHttpRequest.builder().headers(this.buildHeader(request)).build();
    }

    private Map<String, Object> objectToMap(Object obj) {
        Class<?> cla = obj.getClass();
        Field[] fields = cla.getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Arrays.stream(fields).filter(filed -> !Modifier.isStatic(filed.getModifiers())).forEach(field -> this.setMapByField((Field)field, (Map<String, Object>)map, obj));
        return map;
    }

    private void setMapByField(Field field, Map<String, Object> map, Object obj) {
        Object value;
        field.setAccessible(true);
        String keyName = field.getName();
        try {
            value = field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Fail to convert " + obj.getClass() + "[{0}] to [Map].");
        }
        map.put(keyName, value);
    }

    private Map<String, String> buildHeader(HttpServletRequest request) {
        Enumeration names = request.getHeaderNames();
        HashMap<String, String> header = new HashMap<String, String>();
        if (names == null) {
            return header;
        }
        while (names.hasMoreElements()) {
            String actualName;
            String name = (String)names.nextElement();
            if (StringUtils.isBlank((String)name) || !this.whiteHeaders.contains(actualName = name.trim().toLowerCase(Locale.ROOT)) || Objects.equals(StringUtils.toLowerCase((String)name), "cookie")) continue;
            header.put(name, request.getHeader(name));
        }
        return header;
    }

    private void putGlobalContext(String key, String value, int ttl) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
            return;
        }
        this.putGlobalContext.process(key, value);
        this.putGlobalContext.process(TTL_PREFIX + key, String.valueOf(ttl));
    }

    private void clearSourceHttpInfo(Input input) {
        this.clearGlobalContext(HTTP_REQUEST_URI);
        this.clearGlobalContext(HTTP_REMOTE_ADDR);
        this.clearGlobalContext(HTTP_METHOD);
        this.clearGlobalContext(HTTP_REQUEST);
        List ttlHeaderKeys = (List)ObjectUtils.getIfNull((Object)input.get("headersWithTtl", List.class), Collections::emptyList);
        ttlHeaderKeys.forEach(this::clearGlobalContext);
    }

    private void clearGlobalContext(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        this.removeGlobalContext.process(key);
        this.removeGlobalContext.process(TTL_PREFIX + key);
    }

    private void putHttpGlobalContext(Input input) {
        Map context = (Map)input.get("context", Map.class);
        if (MapUtils.isNotEmpty((Map)context)) {
            context.forEach((arg_0, arg_1) -> ((PutGlobalContext)this.putGlobalContext).process(arg_0, arg_1));
        }
    }

    private void clearHttpGlobalContext(Input input) {
        Map context = (Map)input.get("context", Map.class);
        if (MapUtils.isNotEmpty((Map)context)) {
            context.keySet().forEach(arg_0 -> ((RemoveGlobalContext)this.removeGlobalContext).process(arg_0));
        }
    }
}

