/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fit.broker.server.entity.FileDescriptor;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteFileNode
extends AbstractActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteFileNode.class);
    public static final String NAME = "Write File";
    private static final String HTTP_HEADER_CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_DISPOSITION_VALUE_PREFIX = "attachment;filename=";

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        String fileName;
        FileDescriptor fileDescriptor = (FileDescriptor)input.get("file", FileDescriptor.class);
        if (fileDescriptor == null) {
            return null;
        }
        HttpServletResponse response = (HttpServletResponse)input.require("response", HttpServletResponse.class);
        try {
            fileName = URLEncoder.encode(fileDescriptor.getFileName(), StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        byte[] fileContent = fileDescriptor.getFileContent();
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setContentLength(fileContent.length);
        ServletContext servletContext = (ServletContext)input.require("servletContext", ServletContext.class);
        response.setContentType(servletContext.getMimeType(fileName));
        response.setHeader(HTTP_HEADER_CONTENT_DISPOSITION, CONTENT_DISPOSITION_VALUE_PREFIX + fileName);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(fileContent);
            outputStream.flush();
        }
        catch (IOException e) {
            log.warn("Write content to servlet output stream error: {}", (Object)e.getMessage());
            log.debug("Write content to servlet output stream exception stack trace:", (Throwable)e);
        }
        return null;
    }
}

