/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.workflow.AbstractActivity;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Output;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseNode
extends AbstractActivity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteResponseNode.class);
    public static final String NAME = "Write Response";

    public String getName() {
        return NAME;
    }

    public Output process(Input input) {
        int code = (Integer)ObjectUtils.nullIf((Object)input.get("code", Integer.class), (Object)200);
        String data = (String)input.get("data", String.class);
        if (data == null) {
            return null;
        }
        HttpServletResponse response = (HttpServletResponse)input.require("response", HttpServletResponse.class);
        this.writeResponseHeader(response, input);
        this.writeResponse(response, code, data);
        return null;
    }

    private void writeResponseHeader(HttpServletResponse response, Input input) {
        Map data = (Map)input.get("responseHeaders", Map.class);
        if (data == null) {
            return;
        }
        data.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
    }

    private void writeResponse(HttpServletResponse response, int status, String message) {
        String contentType = response.getContentType();
        if (StringUtils.isBlank((String)contentType)) {
            response.setContentType("application/json; charset=utf-8");
        }
        response.setStatus(status);
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        try (PrintWriter pw = response.getWriter();){
            pw.write(message);
            pw.flush();
        }
        catch (IOException e) {
            log.warn("Write content to print writer error: {}", (Object)e.getMessage());
            log.debug("Write content to print writer exception stack trace:", (Throwable)e);
        }
    }
}

